/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.QuestRewardEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.MutablePair;

public class RewardManager {
    private static final List<QuestRewardEntry> indivRewards = new ArrayList<QuestRewardEntry>();
    private static final List<QuestRewardEntry> minorRewards = new ArrayList<QuestRewardEntry>();
    private static final List<QuestRewardEntry> majorRewards = new ArrayList<QuestRewardEntry>();

    public static void addIndivRewards(List<QuestRewardEntry> rewards) {
        indivRewards.addAll(rewards);
    }

    public static void addMinorRewards(List<QuestRewardEntry> rewards) {
        minorRewards.addAll(rewards);
    }

    public static void addMajorRewards(List<QuestRewardEntry> rewards) {
        majorRewards.addAll(rewards);
    }

    public static void clearAll() {
        indivRewards.clear();
        minorRewards.clear();
        majorRewards.clear();
    }

    public static ItemStack getIndivReward(RandomSource randomSource, float difficulty) {
        int amount;
        QuestRewardEntry rewardEntry = indivRewards.get(randomSource.nextInt(indivRewards.size()));
        float value = difficulty * CommonConfig.indivRewardValueScale;
        value -= rewardEntry.cost() * (float)amount;
        for (amount = rewardEntry.minCount(); amount < rewardEntry.maxCount() && value < rewardEntry.cost() * (float)amount; ++amount) {
        }
        return new ItemStack((ItemLike)rewardEntry.item(), amount);
    }

    public static List<ItemStack> getMinorRewards(RandomSource randomSource) {
        List<MutablePair> availableEntries;
        int maxItems;
        int items = Math.min(CommonConfig.minorRewardMinItems, minorRewards.size());
        items = items <= (maxItems = Math.min(CommonConfig.minorRewardMaxItems, minorRewards.size())) ? items : randomSource.nextInt(items, maxItems);
        List<QuestRewardEntry> sample = new ArrayList<QuestRewardEntry>(minorRewards);
        Collections.shuffle(sample);
        sample = sample.subList(0, items);
        List<MutablePair> entries = sample.stream().map(entry -> new MutablePair((Object)entry.minCount(), entry)).toList();
        double totalCost = entries.stream().mapToDouble(pair -> (float)((Integer)pair.getLeft()).intValue() * ((QuestRewardEntry)pair.getRight()).cost()).sum();
        while (totalCost < (double)CommonConfig.minorRewardValue && !(availableEntries = entries.stream().filter(pair -> (Integer)pair.getLeft() < ((QuestRewardEntry)pair.getRight()).maxCount()).toList()).isEmpty()) {
            MutablePair availablePair = availableEntries.get(randomSource.nextInt(availableEntries.size()));
            availablePair.setLeft((Object)((Integer)availablePair.getLeft() + 1));
            totalCost = entries.stream().mapToDouble(pair -> (float)((Integer)pair.getLeft()).intValue() * ((QuestRewardEntry)pair.getRight()).cost()).sum();
        }
        return entries.stream().map(pair -> new ItemStack((ItemLike)((QuestRewardEntry)pair.getRight()).item(), ((Integer)pair.getLeft()).intValue())).toList();
    }

    public static List<ItemStack> getMajorRewards(RandomSource randomSource) {
        List<MutablePair> availableEntries;
        int maxItems;
        int items = Math.min(CommonConfig.majorRewardMinItems, majorRewards.size());
        items = items <= (maxItems = Math.min(CommonConfig.majorRewardMaxItems, majorRewards.size())) ? items : randomSource.nextInt(items, maxItems);
        List<QuestRewardEntry> sample = new ArrayList<QuestRewardEntry>(majorRewards);
        Collections.shuffle(sample);
        sample = sample.subList(0, items);
        List<MutablePair> entries = sample.stream().map(entry -> new MutablePair((Object)entry.minCount(), entry)).toList();
        double totalCost = entries.stream().mapToDouble(pair -> (float)((Integer)pair.getLeft()).intValue() * ((QuestRewardEntry)pair.getRight()).cost()).sum();
        while (totalCost < (double)CommonConfig.majorRewardValue && !(availableEntries = entries.stream().filter(pair -> (Integer)pair.getLeft() < ((QuestRewardEntry)pair.getRight()).maxCount()).toList()).isEmpty()) {
            MutablePair availablePair = availableEntries.get(randomSource.nextInt(availableEntries.size()));
            availablePair.setLeft((Object)((Integer)availablePair.getLeft() + 1));
            totalCost = entries.stream().mapToDouble(pair -> (float)((Integer)pair.getLeft()).intValue() * ((QuestRewardEntry)pair.getRight()).cost()).sum();
        }
        return entries.stream().map(pair -> new ItemStack((ItemLike)((QuestRewardEntry)pair.getRight()).item(), ((Integer)pair.getLeft()).intValue())).toList();
    }
}

