/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.ConditionManager;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class BiomeQuest
extends Quest {
    public static final MapCodec<BiomeQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)ItemStack.CODEC.fieldOf("reward").forGetter(Quest::getReward), (App)ResourceLocation.CODEC.fieldOf("biome_res").forGetter(BiomeQuest::getBiomeRes), (App)Species.getBY_IDENTIFIER_CODEC().listOf().fieldOf("precomp_species").forGetter(BiomeQuest::getPreCompList)).apply((Applicative)instance, BiomeQuest::new));
    public final ResourceLocation biomeRes;
    public final List<Species> preCompList;

    public BiomeQuest(ServerLevel level) {
        this(level, ConditionManager.getRandomBiomeCondition(level));
    }

    private BiomeQuest(ServerLevel level, Pair<ResourceLocation, Float> pair) {
        super(level, CommonConfig.biomeQuestDifficulty * ((Float)pair.getSecond()).floatValue());
        Registry registry = level.registryAccess().registryOrThrow(Registries.BIOME);
        Biome biome = (Biome)registry.get((ResourceLocation)pair.getFirst());
        this.biomeRes = (ResourceLocation)pair.getFirst();
        this.preCompList = CobblemonSpawnPools.WORLD_SPAWN_POOL.getDetails().stream().filter(spawnDetail -> {
            for (SpawningCondition cond : spawnDetail.getConditions()) {
                if (cond.getBiomes() == null) continue;
                for (RegistryLikeCondition c : cond.getBiomes()) {
                    if (!c.fits((Object)biome, registry)) continue;
                    return true;
                }
            }
            return false;
        }).map(spawnDetail -> {
            String specie = ((PokemonSpawnDetail)spawnDetail).getPokemon().getSpecies();
            if (specie == null) {
                return null;
            }
            return specie.toLowerCase();
        }).filter(Objects::nonNull).distinct().map(arg_0 -> ((PokemonSpecies)PokemonSpecies.INSTANCE).getByName(arg_0)).toList();
    }

    public BiomeQuest(ServerLevel level, ResourceLocation biomeRes, List<Species> preCompList) {
        super(level);
        this.biomeRes = biomeRes;
        this.preCompList = preCompList;
    }

    public BiomeQuest(long timestamp, ItemStack reward, ResourceLocation biomeRes, List<Species> preCompList) {
        super(timestamp, reward);
        this.biomeRes = biomeRes;
        this.preCompList = preCompList;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        return this.preCompList.contains(pokemon.getSpecies());
    }

    @Override
    public String getModifierString() {
        return this.biomeRes.getPath();
    }

    public ResourceLocation getBiomeRes() {
        return this.biomeRes;
    }

    public List<Species> getPreCompList() {
        return this.preCompList;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.BIOME;
    }
}

