/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MoveQuest
extends Quest {
    public static final MapCodec<MoveQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)ItemStack.CODEC.fieldOf("reward").forGetter(Quest::getReward), (App)MoveTemplate.getBY_STRING_CODEC().fieldOf("quest_move").forGetter(MoveQuest::getMove)).apply((Applicative)instance, MoveQuest::new));
    public final MoveTemplate move;

    public MoveQuest(ServerLevel level) {
        super(level, CommonConfig.moveQuestDifficulty);
        List moves = Moves.INSTANCE.all();
        this.move = (MoveTemplate)moves.get(level.getRandom().nextInt(moves.size()));
    }

    public MoveQuest(ServerLevel level, MoveTemplate move) {
        super(level);
        this.move = move;
    }

    public MoveQuest(long timestamp, ItemStack reward, MoveTemplate move) {
        super(timestamp, reward);
        this.move = move;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        for (Move move : pokemon.getMoveSet().getMoves()) {
            if (this.move != move.getTemplate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModifierString() {
        return this.move.getDisplayName().getString();
    }

    public MoveTemplate getMove() {
        return this.move;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.MOVE;
    }
}

