/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.pokedex.Dexes;
import com.cobblemon.mod.common.api.pokedex.def.PokedexDef;
import com.cobblemon.mod.common.api.pokedex.entry.PokedexEntry;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RegionQuest
extends Quest {
    public static final MapCodec<RegionQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)ItemStack.CODEC.fieldOf("reward").forGetter(Quest::getReward), (App)ResourceLocation.CODEC.fieldOf("region").forGetter(RegionQuest::getRegion)).apply((Applicative)instance, RegionQuest::new));
    public final ResourceLocation region;

    public RegionQuest(ServerLevel level) {
        super(level, CommonConfig.regionQuestDifficulty);
        ArrayList dexes = new ArrayList(Dexes.INSTANCE.getDexEntryMap().keySet());
        this.region = (ResourceLocation)dexes.get(level.getRandom().nextInt(dexes.size()));
    }

    public RegionQuest(ServerLevel level, ResourceLocation region) {
        super(level);
        this.region = region;
    }

    public RegionQuest(long timestamp, ItemStack reward, ResourceLocation region) {
        super(timestamp, reward);
        this.region = region;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        PokedexDef dex = (PokedexDef)Dexes.INSTANCE.getDexEntryMap().get(this.region);
        if (dex == null) {
            return false;
        }
        for (PokedexEntry entry : dex.getEntries()) {
            if (PokemonSpecies.INSTANCE.getByIdentifier(entry.getSpeciesId()) != pokemon.getSpecies()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModifierString() {
        String str = this.region.getPath();
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public ResourceLocation getRegion() {
        return this.region;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.REGION;
    }
}

