/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab;

import com.kreidev.cbmnfieldlab.FieldLabBlockEntity;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.gui.FieldLabMenu;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import com.kreidev.cbmnfieldlab.quest.QuestManager;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldLabBlock
extends BaseEntityBlock {
    public static final MapCodec<FieldLabBlock> CODEC = FieldLabBlock.simpleCodec(FieldLabBlock::new);
    public static final VoxelShape NORTH_AABB_TOP = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)10.0, (double)14.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)9.0, (double)14.0, (double)13.0, (double)9.0), Block.box((double)2.0, (double)13.0, (double)1.0, (double)14.0, (double)15.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)2.0, (double)10.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)14.0, (double)13.0), Block.box((double)14.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0)});
    public static final VoxelShape SOUTH_AABB_TOP = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)1.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)13.0, (double)7.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)15.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)2.0, (double)15.0), Block.box((double)14.0, (double)0.0, (double)3.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)2.0, (double)14.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0)});
    public static final VoxelShape EAST_AABB_TOP = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)2.0, (double)6.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)2.0, (double)2.0, (double)7.0, (double)13.0, (double)14.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0), Block.box((double)6.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0, (double)14.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0), Block.box((double)3.0, (double)0.0, (double)14.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0)});
    public static final VoxelShape WEST_AABB_TOP = Shapes.or((VoxelShape)Block.box((double)10.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)2.0, (double)2.0, (double)9.0, (double)13.0, (double)14.0), Block.box((double)1.0, (double)13.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)14.0, (double)13.0, (double)14.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)14.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0)});
    public static final VoxelShape NORTH_AABB_BOTTOM = Shapes.or((VoxelShape)Block.box((double)2.0, (double)8.0, (double)1.0, (double)14.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)16.0, (double)13.0), Block.box((double)14.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0)});
    public static final VoxelShape SOUTH_AABB_BOTTOM = Shapes.or((VoxelShape)Block.box((double)2.0, (double)8.0, (double)4.0, (double)14.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)14.0, (double)1.0, (double)3.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)3.0, (double)2.0, (double)16.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)1.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0, (double)16.0)});
    public static final VoxelShape EAST_AABB_BOTTOM = Shapes.or((VoxelShape)Block.box((double)4.0, (double)8.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)3.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)3.0, (double)1.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)14.0), Block.box((double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0)});
    public static final VoxelShape WEST_AABB_BOTTOM = Shapes.or((VoxelShape)Block.box((double)1.0, (double)8.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)14.0, (double)13.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)13.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0)});
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;

    public FieldLabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected InteractionResult useWithoutItem(final BlockState blockState, Level level, final BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level instanceof ServerLevel && player instanceof ServerPlayer) {
            final ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf buf) {
                    if (blockState.getValue(HALF) == DoubleBlockHalf.UPPER) {
                        buf.writeBlockPos(blockPos.below());
                    } else {
                        buf.writeBlockPos(blockPos);
                    }
                    CompoundTag tag = new CompoundTag();
                    DataResult result = PlayerQuestContainer.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)QuestManager.getQuestContainer(serverPlayer));
                    result.resultOrPartial(error -> PokemonFieldLab.LOGGER.error("PlayerQuestContainer data was not saved \n" + error)).ifPresent(nbt -> tag.put("quest_container", nbt));
                    buf.writeNbt((Tag)tag);
                }

                @NotNull
                public Component getDisplayName() {
                    return Component.translatable((String)"menu.%s.%s", (Object[])new Object[]{"cbmnfieldlab", "pokemon_field_lab"});
                }

                public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                    return new FieldLabMenu(i, inventory, blockPos, (ServerPlayer)player);
                }
            });
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)));
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof FieldLabBlockEntity) {
                FieldLabBlockEntity be = (FieldLabBlockEntity)blockEntity;
                be.setUser(serverPlayer.getUUID());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((DoubleBlockHalf)blockState.getValue(HALF)) {
            default -> throw new MatchException(null, null);
            case DoubleBlockHalf.UPPER -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case NORTH: {
                        yield NORTH_AABB_TOP;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB_TOP;
                    }
                    case EAST: {
                        yield EAST_AABB_TOP;
                    }
                }
                yield WEST_AABB_TOP;
            }
            case DoubleBlockHalf.LOWER -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case NORTH: {
                        yield NORTH_AABB_BOTTOM;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB_BOTTOM;
                    }
                    case EAST: {
                        yield EAST_AABB_BOTTOM;
                    }
                }
                yield WEST_AABB_BOTTOM;
            }
        };
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return blockState2.getBlock() instanceof FieldLabBlock && blockState2.getValue(HALF) != doubleBlockHalf ? (BlockState)blockState2.setValue(HALF, (Comparable)doubleBlockHalf) : Blocks.AIR.defaultBlockState();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    protected boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPosBelow = blockPos.below();
        BlockState blockStateBelow = levelReader.getBlockState(blockPosBelow);
        if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return blockStateBelow.isFaceSturdy((BlockGetter)levelReader, blockPosBelow, Direction.UP);
        }
        return blockStateBelow.is((Block)this);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        level.setBlock(blockPos.above(), (BlockState)blockState.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        level.blockUpdated(blockPos, Blocks.AIR);
        blockState.updateNeighbourShapes((LevelAccessor)level, blockPos, 3);
    }

    protected void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.is(blockState2.getBlock())) {
            super.onRemove(blockState, level, blockPos, blockState2, bl);
        }
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{HALF});
        builder.add(new Property[]{OPEN});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        Level level = blockPlaceContext.getLevel();
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.above()).canBeReplaced(blockPlaceContext)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getHorizontalDirection())).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    @NotNull
    protected BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new FieldLabBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : FieldLabBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)PokemonFieldLab.FIELD_LAB_BLOCK_ENTITY.get()), FieldLabBlockEntity::serverTick);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

