/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.client.storage.ClientParty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.kreidev.cbmnfieldlab.gui.FieldLabMenu;
import com.kreidev.cbmnfieldlab.gui.FieldLabScreen;
import com.kreidev.cbmnfieldlab.gui.PartyPanelSlot;
import com.kreidev.cbmnfieldlab.gui.SubmitButton;
import com.kreidev.cbmnfieldlab.gui.SubmitConfirmButton;
import com.kreidev.cbmnfieldlab.network.SubmitPacket;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class PartyPanelWidget
extends SoundlessWidget {
    public static final ResourceLocation PARTY_PANEL_RES = MiscUtilsKt.cobblemonResource((String)"textures/gui/pc/party_panel.png");
    public final List<PartyPanelSlot> partySlots = new ArrayList<PartyPanelSlot>();
    public final FieldLabScreen parent;
    public final ClientParty party;
    public final SubmitButton submitButton;
    public final SubmitConfirmButton submitYesButton;
    public final SubmitConfirmButton submitNoButton;
    public boolean displayConfirmSubmit = false;

    public PartyPanelWidget(int pX, int pY, FieldLabScreen parent, ClientParty party) {
        super(pX, pY, 263, 155, (Component)Component.literal((String)"PartyPanelOverlay"));
        this.parent = parent;
        this.party = party;
        this.setupPartySlot();
        this.submitButton = new SubmitButton(this.getX() + 194, this.getY() + 124, ignore -> {});
        this.addWidget((GuiEventListener)this.submitButton);
        this.submitYesButton = new SubmitConfirmButton(this.getX() + 190, this.getY() + 131, LocalizationUtilsKt.lang((String)"ui.generic.yes", (Object[])new Object[0]), ignore -> {});
        this.addWidget((GuiEventListener)this.submitYesButton);
        this.submitNoButton = new SubmitConfirmButton(this.getX() + 226, this.getY() + 131, LocalizationUtilsKt.lang((String)"ui.generic.no", (Object[])new Object[0]), ignore -> {});
        this.addWidget((GuiEventListener)this.submitNoButton);
    }

    private void setupPartySlot() {
        for (int partyIndex = 0; partyIndex < 6; ++partyIndex) {
            int partyX = this.getX() + 193;
            int partyY = this.getY() + 8;
            if (partyIndex > 0) {
                boolean isEven = partyIndex % 2 == 0;
                int offsetIndex = (partyIndex - (isEven ? 0 : 1)) / 2;
                int offsetX = isEven ? 0 : 31;
                int offsetY = isEven ? 0 : 8;
                partyX += offsetX;
                partyY += 31 * offsetIndex + offsetY;
            }
            PartyPanelSlot slot = new PartyPanelSlot(partyX, partyY, this, this.party, new PartyPosition(partyIndex), this::onSlotClicked);
            this.addWidget((GuiEventListener)slot);
            this.partySlots.add(slot);
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        PoseStack matrices = guiGraphics.pose();
        FieldLabScreen.GuiUtilsKtExt.blitk(matrices, PARTY_PANEL_RES, this.getX() + 182, this.getY() - 19, 169, 82);
        FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)LocalizationUtilsKt.lang((String)"ui.party", (Object[])new Object[0])), this.getX() + 213, (double)this.getY() - 15.5, true, true);
        for (PartyPanelSlot slot : this.partySlots) {
            slot.render(guiGraphics, mouseX, mouseY, delta);
        }
        PlayerQuestContainer container = ((FieldLabMenu)this.parent.getMenu()).questContainer;
        if (this.parent.previewPokemon != null && container.hasEligible(this.parent.previewPokemon)) {
            if (this.displayConfirmSubmit) {
                FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)Component.translatable((String)"cbmnfieldlab.ui.field_lab.submit")), this.getX() + 223, this.getY() + 119, true, false);
                this.submitYesButton.render(guiGraphics, mouseX, mouseY, delta);
                this.submitNoButton.render(guiGraphics, mouseX, mouseY, delta);
            } else {
                this.submitButton.render(guiGraphics, mouseX, mouseY, delta);
            }
        }
    }

    public void onSlotClicked(Button button) {
        if (!(button instanceof PartyPanelSlot)) {
            return;
        }
        PartyPanelSlot slot = (PartyPanelSlot)button;
        Pokemon pokemon = slot.getPokemon();
        if (pokemon == this.parent.previewPokemon) {
            pokemon = null;
        }
        this.parent.setPreviewPokemon(pokemon);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.displayConfirmSubmit) {
            if (this.submitYesButton.isHovered()) {
                this.onSubmit();
            }
            if (this.submitNoButton.isHovered()) {
                this.displayConfirmSubmit = false;
            }
        } else if (this.submitButton.isHovered()) {
            this.displayConfirmSubmit = true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void onSubmit() {
        this.displayConfirmSubmit = false;
        if (this.parent.previewPokemon == null) {
            return;
        }
        PartyPosition partyPosition = this.party.getPosition(this.parent.previewPokemon);
        if (partyPosition == null) {
            return;
        }
        NetworkManager.sendToServer((CustomPacketPayload)new SubmitPacket(partyPosition.getSlot()));
    }
}

