/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.gui;

import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.gui.FieldLabScreen;
import com.kreidev.cbmnfieldlab.gui.QuestPanelWidget;
import com.kreidev.cbmnfieldlab.gui.RerollButton;
import com.kreidev.cbmnfieldlab.network.RerollPacket;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class QuestSlotWidget
extends SoundlessWidget
implements CobblemonRenderable {
    public static final ResourceLocation QUEST_SELECTED_RES = PokemonFieldLab.resLoc("textures/gui/%s/quest_slot_active.png", "pokemon_field_lab");
    public final QuestPanelWidget parent;
    public final Quest quest;
    public final RerollButton rerollButton;
    public final int index;

    public QuestSlotWidget(int pX, int pY, QuestPanelWidget parent, Quest quest, int index) {
        super(pX, pY, 166, 38, (Component)Component.literal((String)"QuestSlot"));
        this.parent = parent;
        this.quest = quest;
        this.index = index;
        this.rerollButton = new RerollButton(pX + 1, pY + 9, this, this::onReroll);
        this.addWidget((GuiEventListener)this.rerollButton);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        PoseStack matrices = guiGraphics.pose();
        float alpha = Math.min(1.0f, (float)this.parent.parent.ticksElapsed / 10.0f);
        if (this.parent.parent.previewPokemon != null && this.quest.isEligible(this.parent.parent.previewPokemon)) {
            FieldLabScreen.GuiUtilsKtExt.blitk(matrices, QUEST_SELECTED_RES, this.getX(), this.getY(), 38, 166, alpha, 1.0f);
        }
        String[] parts = Component.translatable((String)("cbmnfieldlab.ui.field_lab.quest." + this.quest.getType().id())).getString().split("\\n");
        int startY = this.getY() + 16;
        int offsetY = 0;
        if (parts.length == 2) {
            startY = this.getY() + 10;
            offsetY = 8;
        } else if (parts.length == 3) {
            startY = this.getY() + 7;
            offsetY = 8;
        }
        for (int i = 0; i < parts.length; ++i) {
            FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), QuestSlotWidget.strToCompWithModifier(parts[i], this.quest.getModifierString()), this.getX() + 28, startY + offsetY * i, false, true, 1.0f, 0.9f * alpha);
        }
        FieldLabScreen.RenderHelperKtExt.drawScaledText(guiGraphics, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold((MutableComponent)Component.literal((String)(this.quest.getReward().getCount() + "x"))), this.getX() + 150, this.getY() + 27, true, true, 1.0f, 0.9f * alpha);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        guiGraphics.renderItem(this.quest.getReward().copyWithCount(1), this.getX() + 143, this.getY() + 5);
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, this.quest.getReward().copyWithCount(1), this.getX() + 143, this.getY() + 5);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.rerollButton.render(guiGraphics, mouseX, mouseY, delta);
    }

    public static MutableComponent strToCompWithModifier(String str, String modifier) {
        if (str.contains("___")) {
            String[] parts = str.split("___", -1);
            return Component.literal((String)parts[0]).append((Component)Component.literal((String)modifier)).append(parts[1]);
        }
        return Component.literal((String)str);
    }

    public void onReroll(Button button) {
        if (this.quest.getTimeStamp() + (long)CommonConfig.rerollTimeSeconds * 20L > this.parent.parent.getGameTime()) {
            return;
        }
        NetworkManager.sendToServer((CustomPacketPayload)new RerollPacket(this.index));
    }
}

