/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.network;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.network.RerollPacket;
import com.kreidev.cbmnfieldlab.network.SubmitPacket;
import com.kreidev.cbmnfieldlab.quest.QuestManager;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class FieldLabNetworkManager {
    public static void registerPackets() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RerollPacket.TYPE, RerollPacket.STREAM_CODEC, FieldLabNetworkManager::rerollQuest);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SubmitPacket.TYPE, SubmitPacket.STREAM_CODEC, FieldLabNetworkManager::submitQuest);
    }

    public static void submitQuest(SubmitPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Pokemon pokemon = PlayerExtensionsKt.party((ServerPlayer)player2).get(packet.partyPositionSlot());
        if (pokemon == null) {
            return;
        }
        QuestManager.submitPokemon(player2, pokemon);
    }

    public static void rerollQuest(RerollPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        int index = packet.index();
        QuestManager.rerollQuest(player2, index);
    }

    public static <B extends FriendlyByteBuf, T> StreamCodec<B, T> fromCodec(final Codec<T> codec) {
        return new StreamCodec<B, T>(){

            public T decode(B buf) {
                CompoundTag tag = buf.readNbt();
                return codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Decode error: " + error)).orElseThrow();
            }

            public void encode(B buf, T value) {
                codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Encode error: " + error)).ifPresent(arg_0 -> buf.writeNbt(arg_0));
            }
        };
    }
}

