/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.network.FieldLabNetworkManager;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.RewardManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerQuestContainer {
    public static final MapCodec<PlayerQuestContainer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("finishedQuest").forGetter(PlayerQuestContainer::getFinishedQuests), (App)Quest.CODEC.fieldOf("quest1").forGetter(PlayerQuestContainer::firstQuest), (App)Quest.CODEC.fieldOf("quest2").forGetter(PlayerQuestContainer::secondQuest), (App)Quest.CODEC.fieldOf("quest3").forGetter(PlayerQuestContainer::thirdQuest), (App)ItemStack.CODEC.listOf().fieldOf("next_minor_list").forGetter(PlayerQuestContainer::getNextMinorRewards), (App)ItemStack.CODEC.listOf().fieldOf("next_major_list").forGetter(PlayerQuestContainer::getNextMajorRewards)).apply((Applicative)instance, PlayerQuestContainer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerQuestContainer> STREAM_CODEC = FieldLabNetworkManager.fromCodec(CODEC.codec());
    @NotNull
    public Quest quest1;
    @NotNull
    public Quest quest2;
    @NotNull
    public Quest quest3;
    @NotNull
    public List<ItemStack> nextMinorRewards;
    @NotNull
    public List<ItemStack> nextMajorRewards;
    public int finishedQuests;

    public PlayerQuestContainer(int finishedQuests, @NotNull Quest quest1, @NotNull Quest quest2, @NotNull Quest quest3, @NotNull List<ItemStack> nextMinorRewards, @NotNull List<ItemStack> nextMajorRewards) {
        this.finishedQuests = finishedQuests;
        this.quest1 = quest1;
        this.quest2 = quest2;
        this.quest3 = quest3;
        this.nextMinorRewards = nextMinorRewards;
        this.nextMajorRewards = nextMajorRewards;
    }

    public PlayerQuestContainer(ServerLevel level) {
        this.finishedQuests = 0;
        this.quest1 = Quest.getRandomQuest(level);
        this.quest2 = Quest.getRandomQuest(level);
        this.quest3 = Quest.getRandomQuest(level);
        this.nextMinorRewards = RewardManager.getMinorRewards(level.getRandom());
        this.nextMajorRewards = RewardManager.getMajorRewards(level.getRandom());
    }

    public void incrementFinishedQuests() {
        ++this.finishedQuests;
    }

    public int getFinishedQuests() {
        return this.finishedQuests;
    }

    @NotNull
    public List<Quest> getQuests() {
        return List.of(this.quest1, this.quest2, this.quest3);
    }

    @Nullable
    public Quest getQuest(int index) {
        return switch (index) {
            case 0 -> this.quest1;
            case 1 -> this.quest2;
            case 2 -> this.quest3;
            default -> null;
        };
    }

    @NotNull
    public Quest firstQuest() {
        return this.quest1;
    }

    @NotNull
    public Quest secondQuest() {
        return this.quest2;
    }

    @NotNull
    public Quest thirdQuest() {
        return this.quest3;
    }

    @NotNull
    public List<ItemStack> getNextMinorRewards() {
        return this.nextMinorRewards;
    }

    @NotNull
    public List<ItemStack> getNextMajorRewards() {
        return this.nextMajorRewards;
    }

    public int getQuestIndex(Quest quest) {
        if (quest.equals(this.quest1)) {
            return 0;
        }
        if (quest.equals(this.quest2)) {
            return 1;
        }
        if (quest.equals(this.quest3)) {
            return 2;
        }
        return -1;
    }

    public boolean hasQuest(Quest quest) {
        return this.getQuestIndex(quest) != -1;
    }

    public boolean replaceQuest(Quest oldQuest, @NotNull Quest newQuest) {
        return this.replaceQuest(this.getQuestIndex(oldQuest), newQuest);
    }

    public boolean replaceQuest(int index, @NotNull Quest newQuest) {
        return switch (index) {
            case 0 -> {
                this.quest1 = newQuest;
                yield true;
            }
            case 1 -> {
                this.quest2 = newQuest;
                yield true;
            }
            case 2 -> {
                this.quest3 = newQuest;
                yield true;
            }
            default -> false;
        };
    }

    public boolean hasEligible(Pokemon pokemon) {
        return this.quest1.isEligible(pokemon) || this.quest2.isEligible(pokemon) || this.quest3.isEligible(pokemon);
    }

    public void replaceMinorRewards(List<ItemStack> rewards) {
        this.nextMinorRewards = rewards;
    }

    public void replaceMajorRewards(List<ItemStack> rewards) {
        this.nextMajorRewards = rewards;
    }

    public String toString() {
        return "PlayerQuestContainer{quest1=" + String.valueOf(this.quest1) + ", quest2=" + String.valueOf(this.quest2) + ", quest3=" + String.valueOf(this.quest3) + ", finishedQuests=" + this.finishedQuests + "}";
    }
}

