/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.PokemonFieldLab;
import com.kreidev.cbmnfieldlab.network.RefreshScreenPacket;
import com.kreidev.cbmnfieldlab.quest.PlayerQuestContainer;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.RewardManager;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class QuestManager
extends SavedData {
    public static final Codec<Map<UUID, PlayerQuestContainer>> CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)PlayerQuestContainer.CODEC.codec());
    public static QuestManager INSTANCE;
    private final Map<UUID, PlayerQuestContainer> playerQuests;

    public QuestManager() {
        this.playerQuests = new HashMap<UUID, PlayerQuestContainer>();
    }

    public QuestManager(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("PlayerCobblemonQuests")) {
            DataResult result = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("PlayerCobblemonQuests"));
            this.playerQuests = new HashMap<UUID, PlayerQuestContainer>(result.resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Quest data was not loaded \n" + error)).orElse(Collections.emptyMap()));
        } else {
            this.playerQuests = new HashMap<UUID, PlayerQuestContainer>();
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.getPlayerQuests());
        result.resultOrPartial(error -> PokemonFieldLab.LOGGER.error("Quest data was not saved \n" + error)).ifPresent(nbt -> tag.put("PlayerCobblemonQuests", nbt));
        return tag;
    }

    public Map<UUID, PlayerQuestContainer> getPlayerQuests() {
        return this.playerQuests;
    }

    @NotNull
    public static PlayerQuestContainer getQuestContainer(ServerPlayer player) {
        PlayerQuestContainer container = INSTANCE.getPlayerQuests().get(player.getUUID());
        if (container == null) {
            container = new PlayerQuestContainer((ServerLevel)player.level());
            INSTANCE.getPlayerQuests().put(player.getUUID(), container);
            INSTANCE.setDirty();
        }
        return container;
    }

    public static boolean rerollQuest(ServerPlayer player, Quest quest) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        int index = container.getQuestIndex(quest);
        if (index == -1) {
            return false;
        }
        return QuestManager.rerollQuest(player, index);
    }

    public static boolean rerollQuest(ServerPlayer player, int index) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        Quest quest = container.getQuest(index);
        if (quest == null) {
            return false;
        }
        if (quest.getTimeStamp() + (long)CommonConfig.rerollTimeSeconds > player.level().getGameTime()) {
            return false;
        }
        boolean success = container.replaceQuest(index, Quest.getRandomQuest((ServerLevel)player.level()));
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RefreshScreenPacket(container));
        INSTANCE.setDirty();
        return success;
    }

    public static boolean hasQuest(ServerPlayer player, Quest quest) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        return container.hasQuest(quest);
    }

    public static boolean submitPokemon(@NotNull ServerPlayer player, @NotNull Pokemon pokemon) {
        PlayerQuestContainer container = QuestManager.getQuestContainer(player);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int preFinishedQuests = container.getFinishedQuests();
        int completedQuests = 0;
        List<Quest> quests = container.getQuests();
        for (int i = 0; i < quests.size(); ++i) {
            if (!quests.get(i).isEligible(pokemon)) continue;
            ++completedQuests;
            container.incrementFinishedQuests();
            stacks.add(quests.get(i).getReward());
            container.replaceQuest(i, Quest.getRandomQuest((ServerLevel)player.level()));
        }
        if (preFinishedQuests % 3 + completedQuests >= 9) {
            for (ItemStack stack : container.getNextMajorRewards()) {
                player.getInventory().placeItemBackInInventory(stack);
                PokemonFieldLab.LOGGER.info(String.valueOf(stack));
            }
            container.replaceMajorRewards(RewardManager.getMajorRewards(player.level().getRandom()));
        }
        if (preFinishedQuests % 3 + completedQuests >= 3) {
            for (ItemStack stack : container.getNextMinorRewards()) {
                player.getInventory().placeItemBackInInventory(stack);
                PokemonFieldLab.LOGGER.info(String.valueOf(stack));
            }
            container.replaceMinorRewards(RewardManager.getMinorRewards(player.level().getRandom()));
        }
        boolean submitted = false;
        if (completedQuests > 0) {
            PlayerExtensionsKt.party((ServerPlayer)player).remove(pokemon);
            for (ItemStack stack : stacks) {
                player.getInventory().placeItemBackInInventory(stack);
            }
            INSTANCE.setDirty();
            submitted = true;
        }
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RefreshScreenPacket(container));
        return submitted;
    }
}

