/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TypeQuest
extends Quest {
    public static final MapCodec<TypeQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)ItemStack.CODEC.fieldOf("reward").forGetter(Quest::getReward), (App)ElementalType.getBY_STRING_CODEC().fieldOf("quest_elemental_type").forGetter(TypeQuest::getElementalType)).apply((Applicative)instance, TypeQuest::new));
    public final ElementalType elementalType;

    public TypeQuest(ServerLevel level) {
        super(level, CommonConfig.singleTypeQuestDifficulty);
        HashSet<ElementalType> typeSet = new HashSet<ElementalType>();
        for (Species specie : PokemonSpecies.getSpecies()) {
            typeSet.add(specie.getPrimaryType());
            typeSet.add(specie.getSecondaryType());
        }
        ArrayList types = new ArrayList(typeSet);
        this.elementalType = (ElementalType)types.get(level.getRandom().nextInt(types.size()));
    }

    public TypeQuest(ServerLevel level, ElementalType elementalType) {
        super(level);
        this.elementalType = elementalType;
    }

    public TypeQuest(long timestamp, ItemStack reward, ElementalType elementalType) {
        super(timestamp, reward);
        this.elementalType = elementalType;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        for (ElementalType eType : pokemon.getTypes()) {
            if (this.elementalType != eType) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModifierString() {
        return this.elementalType.getDisplayName().getString();
    }

    public ElementalType getElementalType() {
        return this.elementalType;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.SINGLE_TYPE;
    }
}

