/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeightQuest
extends Quest {
    public static final MapCodec<WeightQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)ItemStack.CODEC.fieldOf("reward").forGetter(Quest::getReward), (App)Codec.FLOAT.fieldOf("quest_lower_weight").forGetter(WeightQuest::getLowerWeight), (App)Codec.FLOAT.fieldOf("quest_upper_weight").forGetter(WeightQuest::getUpperWeight)).apply((Applicative)instance, WeightQuest::new));
    public final float lowerWeight;
    public final float upperWeight;

    public WeightQuest(ServerLevel level) {
        super(level, CommonConfig.weightQuestDifficulty);
        float lowerBound = CommonConfig.weightQuestLowerBound;
        float upperBound = CommonConfig.weightQuestUpperBound;
        float minGap = CommonConfig.weightQuestMinGap;
        float maxGap = CommonConfig.weightQuestMaxGap;
        this.lowerWeight = level.getRandom().nextFloat() * (upperBound - lowerBound) + lowerBound;
        this.upperWeight = this.lowerWeight + level.getRandom().nextFloat() * (maxGap - minGap) + minGap;
    }

    public WeightQuest(ServerLevel level, float lowerWeight, float upperWeight) {
        super(level);
        this.lowerWeight = lowerWeight;
        this.upperWeight = upperWeight;
    }

    public WeightQuest(long timestamp, ItemStack reward, float lowerWeight, float upperWeight) {
        super(timestamp, reward);
        this.lowerWeight = lowerWeight;
        this.upperWeight = upperWeight;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        float weight = pokemon.getSpecies().getWeight();
        return this.lowerWeight < weight && weight < this.upperWeight;
    }

    @Override
    public String getModifierString() {
        return String.format("%.2f", Float.valueOf(this.lowerWeight / 10.0f)) + "-" + String.format("%.2f", Float.valueOf(this.upperWeight / 10.0f));
    }

    public float getLowerWeight() {
        return this.lowerWeight;
    }

    public float getUpperWeight() {
        return this.upperWeight;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.WEIGHT;
    }
}

