/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.kreidev.cbmnfieldlab.quest.RewardManager;
import com.kreidev.cbmnfieldlab.quest.type.TypeQuest;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public abstract class Quest {
    public static final Codec<Quest> CODEC = QuestType.REGISTRY.method_39673().dispatch("type", Quest::getType, QuestType::codec);
    public final long timeStamp;
    @NotNull
    public final QuestType<?> type = this.getType();
    @NotNull
    public final class_1799 reward;

    public Quest(class_3218 level) {
        this(level, 1.0f);
    }

    public Quest(class_3218 level, float difficulty) {
        this.timeStamp = level.method_8510();
        this.reward = RewardManager.getIndivReward(level.method_8409(), difficulty);
    }

    public Quest(class_3218 level, @NotNull class_1799 reward) {
        this.timeStamp = level.method_8510();
        this.reward = reward;
    }

    protected Quest(long timeStamp, @NotNull class_1799 reward) {
        this.timeStamp = timeStamp;
        this.reward = reward;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "Quest{timeStamp=" + this.timeStamp + ", type=" + String.valueOf(this.type) + ", modifier=" + this.getModifierString() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Quest)) {
            return false;
        }
        Quest quest = (Quest)obj;
        return this.type == quest.type && this.timeStamp == quest.timeStamp;
    }

    public abstract boolean isEligible(@NotNull Pokemon var1);

    public abstract String getModifierString();

    public float getDifficulty() {
        return 1.0f;
    }

    @NotNull
    public abstract QuestType<?> getType();

    @NotNull
    public class_1799 getReward() {
        return this.reward;
    }

    public static Quest getRandomQuest(class_3218 level) {
        ArrayList<QuestType<Quest>> enabledQuestTypes = new ArrayList<QuestType<Quest>>();
        if (CommonConfig.enableAbilityQuest) {
            enabledQuestTypes.add(QuestTypes.ABILITY);
        }
        if (CommonConfig.enableSingleTypeQuest) {
            enabledQuestTypes.add(QuestTypes.SINGLE_TYPE);
        }
        if (CommonConfig.enableDoubleTypeQuest) {
            enabledQuestTypes.add(QuestTypes.DOUBLE_TYPE);
        }
        if (CommonConfig.enableNatureQuest) {
            enabledQuestTypes.add(QuestTypes.NATURE);
        }
        if (CommonConfig.enableMoveQuest) {
            enabledQuestTypes.add(QuestTypes.MOVE);
        }
        if (CommonConfig.enableSizeQuest) {
            enabledQuestTypes.add(QuestTypes.SIZE);
        }
        if (CommonConfig.enableBaseStatQuest) {
            enabledQuestTypes.add(QuestTypes.BASE_STAT);
        }
        if (CommonConfig.enableWeightQuest) {
            enabledQuestTypes.add(QuestTypes.WEIGHT);
        }
        if (CommonConfig.enableDexNameQuest) {
            enabledQuestTypes.add(QuestTypes.DEX_NAME);
        }
        if (CommonConfig.enableRegionQuest) {
            enabledQuestTypes.add(QuestTypes.REGION);
        }
        if (CommonConfig.enableBiomeQuest) {
            enabledQuestTypes.add(QuestTypes.BIOME);
        }
        if (CommonConfig.enableEvoQuest) {
            enabledQuestTypes.add(QuestTypes.EVO_STAGE);
        }
        if (enabledQuestTypes.isEmpty()) {
            return new TypeQuest(level);
        }
        int randIndex = level.method_8409().method_43048(enabledQuestTypes.size());
        return ((QuestType)enabledQuestTypes.get(randIndex)).randomQuestFactory().apply(level);
    }
}

