/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.ConditionManager;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class BiomeQuest
extends Quest {
    public static final MapCodec<BiomeQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)class_1799.field_24671.fieldOf("reward").forGetter(Quest::getReward), (App)class_2960.field_25139.fieldOf("biome_res").forGetter(BiomeQuest::getBiomeRes), (App)Species.getBY_IDENTIFIER_CODEC().listOf().fieldOf("precomp_species").forGetter(BiomeQuest::getPreCompList)).apply((Applicative)instance, BiomeQuest::new));
    public final class_2960 biomeRes;
    public final List<Species> preCompList;

    public BiomeQuest(class_3218 level) {
        this(level, ConditionManager.getRandomBiomeCondition(level));
    }

    private BiomeQuest(class_3218 level, Pair<class_2960, Float> pair) {
        super(level, CommonConfig.biomeQuestDifficulty * ((Float)pair.getSecond()).floatValue());
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41236);
        class_1959 biome = (class_1959)registry.method_10223((class_2960)pair.getFirst());
        this.biomeRes = (class_2960)pair.getFirst();
        this.preCompList = CobblemonSpawnPools.WORLD_SPAWN_POOL.getDetails().stream().filter(spawnDetail -> {
            for (SpawningCondition cond : spawnDetail.getConditions()) {
                if (cond.getBiomes() == null) continue;
                for (RegistryLikeCondition c : cond.getBiomes()) {
                    if (!c.fits((Object)biome, registry)) continue;
                    return true;
                }
            }
            return false;
        }).map(spawnDetail -> {
            String specie = ((PokemonSpawnDetail)spawnDetail).getPokemon().getSpecies();
            if (specie == null) {
                return null;
            }
            return specie.toLowerCase();
        }).filter(Objects::nonNull).distinct().map(PokemonSpecies::getByName).toList();
    }

    public BiomeQuest(class_3218 level, class_2960 biomeRes, List<Species> preCompList) {
        super(level);
        this.biomeRes = biomeRes;
        this.preCompList = preCompList;
    }

    public BiomeQuest(long timestamp, class_1799 reward, class_2960 biomeRes, List<Species> preCompList) {
        super(timestamp, reward);
        this.biomeRes = biomeRes;
        this.preCompList = preCompList;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        return this.preCompList.contains(pokemon.getSpecies());
    }

    @Override
    public String getModifierString() {
        return this.biomeRes.method_12832();
    }

    public class_2960 getBiomeRes() {
        return this.biomeRes;
    }

    public List<Species> getPreCompList() {
        return this.preCompList;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.BIOME;
    }
}

