/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.pokedex.Dexes;
import com.cobblemon.mod.common.api.pokedex.def.PokedexDef;
import com.cobblemon.mod.common.api.pokedex.entry.PokedexEntry;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class RegionQuest
extends Quest {
    public static final MapCodec<RegionQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)class_1799.field_24671.fieldOf("reward").forGetter(Quest::getReward), (App)class_2960.field_25139.fieldOf("region").forGetter(RegionQuest::getRegion)).apply((Applicative)instance, RegionQuest::new));
    public final class_2960 region;

    public RegionQuest(class_3218 level) {
        super(level, CommonConfig.regionQuestDifficulty);
        ArrayList dexes = new ArrayList(Dexes.INSTANCE.getDexEntryMap().keySet());
        this.region = (class_2960)dexes.get(level.method_8409().method_43048(dexes.size()));
    }

    public RegionQuest(class_3218 level, class_2960 region) {
        super(level);
        this.region = region;
    }

    public RegionQuest(long timestamp, class_1799 reward, class_2960 region) {
        super(timestamp, reward);
        this.region = region;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        PokedexDef dex = (PokedexDef)Dexes.INSTANCE.getDexEntryMap().get(this.region);
        if (dex == null) {
            return false;
        }
        for (PokedexEntry entry : dex.getEntries()) {
            if (PokemonSpecies.getByIdentifier((class_2960)entry.getSpeciesId()) != pokemon.getSpecies()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModifierString() {
        String str = this.region.method_12832();
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public class_2960 getRegion() {
        return this.region;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.REGION;
    }
}

