/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cbmnfieldlab.quest.type;

import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.kreidev.cbmnfieldlab.CommonConfig;
import com.kreidev.cbmnfieldlab.quest.Quest;
import com.kreidev.cbmnfieldlab.quest.QuestType;
import com.kreidev.cbmnfieldlab.quest.QuestTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class StatQuest
extends Quest {
    public static final MapCodec<StatQuest> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("timestamp").forGetter(Quest::getTimeStamp), (App)class_1799.field_24671.fieldOf("reward").forGetter(Quest::getReward), (App)Codec.INT.fieldOf("quest_lower_stat").forGetter(StatQuest::getLowerStatTotal), (App)Codec.INT.fieldOf("quest_upper_stat").forGetter(StatQuest::getUpperStatTotal)).apply((Applicative)instance, StatQuest::new));
    public final int upperStatTotal;
    public final int lowerStatTotal;

    public StatQuest(class_3218 level) {
        super(level, CommonConfig.baseStatQuestDifficulty);
        int lowerBound = CommonConfig.baseStatQuestLowerBound;
        int upperBound = CommonConfig.baseStatQuestUpperBound;
        int minGap = CommonConfig.baseStatQuestMinGap;
        int maxGap = CommonConfig.baseStatQuestMaxGap;
        this.lowerStatTotal = level.method_8409().method_43051(lowerBound, upperBound);
        this.upperStatTotal = this.lowerStatTotal + level.method_8409().method_43051(minGap, maxGap);
    }

    public StatQuest(class_3218 level, int lowerStatTotal, int upperStatTotal) {
        super(level);
        this.lowerStatTotal = lowerStatTotal;
        this.upperStatTotal = upperStatTotal;
    }

    public StatQuest(long timestamp, class_1799 reward, int lowerStatTotal, int upperStatTotal) {
        super(timestamp, reward);
        this.lowerStatTotal = lowerStatTotal;
        this.upperStatTotal = upperStatTotal;
    }

    @Override
    public boolean isEligible(@NotNull Pokemon pokemon) {
        int stats = 0;
        HashMap baseStats = pokemon.getSpecies().getBaseStats();
        stats += ((Integer)baseStats.get(Stats.HP)).intValue();
        stats += ((Integer)baseStats.get(Stats.ATTACK)).intValue();
        stats += ((Integer)baseStats.get(Stats.DEFENCE)).intValue();
        stats += ((Integer)baseStats.get(Stats.SPECIAL_ATTACK)).intValue();
        stats += ((Integer)baseStats.get(Stats.SPECIAL_DEFENCE)).intValue();
        return this.lowerStatTotal < (stats += ((Integer)baseStats.get(Stats.SPEED)).intValue()) && stats < this.upperStatTotal;
    }

    @Override
    public String getModifierString() {
        return this.lowerStatTotal + "-" + this.upperStatTotal;
    }

    public int getUpperStatTotal() {
        return this.upperStatTotal;
    }

    public int getLowerStatTotal() {
        return this.lowerStatTotal;
    }

    @Override
    @NotNull
    public QuestType<?> getType() {
        return QuestTypes.BASE_STAT;
    }
}

