package thelm.spectrumjei.recipe;

import java.util.List;

import mezz.jei.api.helpers.IPlatformFluidHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import thelm.spectrumjei.SpectrumJEI;

public record BlockConversionRecipe(class_2680 input, class_2680 output) {

	public BlockConversionRecipe(class_2248 input, class_2680 output) {
		this(input.method_9564(), output);
	}

	public List<?> inputIngredient() {
		return toIngredient(input);
	}

	public List<?> outputIngredient() {
		return toIngredient(output);
	}

	public boolean isViewable() {
		return !inputIngredient().isEmpty() && !outputIngredient().isEmpty();
	}

	public static List<?> toIngredient(class_2680 state) {
		if(state.method_26204() instanceof class_2404) {
			IPlatformFluidHelper<?> fluidHelper = SpectrumJEI.jeiHelpers.getPlatformFluidHelper();
			class_3611 fluid = state.method_26227().method_15772();
			if(fluid instanceof class_3609 fFluid) {
				fluid = fFluid.method_15751();
			}
			return List.of(fluidHelper.create(fluid, fluidHelper.bucketVolume()));
		}
		else {
			class_1799 stack = new class_1799(state.method_26204());
			return stack.method_7960() ? List.of() : List.of(stack);
		}
	}
}
