package thelm.spectrumjei.recipe.category;

import de.dafuqs.spectrum.recipe.GatedRecipe;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

public abstract class AbstractGatedRecipeCategory<R extends GatedRecipe> extends AbstractUnlockableRecipeCategory<R> {

	public AbstractGatedRecipeCategory(RecipeType<R> recipeType, class_2561 title) {
		super(recipeType, title);
	}

	@Override
	public boolean isHandled(R recipe) {
		return !recipe.isSecret();
	}

	@Override
	public boolean isUnlocked(R recipe) {
		return hasAdvancement(recipe.getRequiredAdvancementIdentifier());
	}

	@Override
	public boolean isVisible(R recipe) {
		return super.isVisible(recipe);
	}

	@Override
	public void draw(R recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		if(!isUnlocked(recipe)) {
			drawLockedText(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		}
	}
}
