package thelm.spectrumjei.recipe.category;

import java.util.List;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import thelm.jeidrawables.gui.render.BlankDrawable;
import thelm.spectrumjei.SpectrumJEI;

public abstract class AbstractUnlockableRecipeCategory<R> implements IRecipeCategory<R> {

	public static final class_2561 HIDDEN_LINE_1 = new class_2588("container.spectrum.rei.pedestal_crafting.recipe_not_unlocked_line_1");
	public static final class_2561 HIDDEN_LINE_2 = new class_2588("container.spectrum.rei.pedestal_crafting.recipe_not_unlocked_line_2");

	public final RecipeType<R> recipeType;
	public final class_2561 title;
	public final IDrawable background;

	public AbstractUnlockableRecipeCategory(RecipeType<R> recipeType, class_2561 title) {
		this.recipeType = recipeType;
		this.title = title;
		background = new BlankDrawable(getWidth(), getHeight());
	}

	@Override
	public class_2960 getUid() {
		return recipeType.getUid();
	}

	@Override
	public Class<? extends R> getRecipeClass() {
		return recipeType.getRecipeClass();
	}

	@Override
	public RecipeType<R> getRecipeType() {
		return recipeType;
	}

	@Override
	public class_2561 getTitle() {
		return title;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	public int getWidth() {
		return 136;
	}

	public abstract int getHeight();

	@Override
	public IDrawable getIcon() {
		return null;
	}

	public abstract boolean isUnlocked(R recipe);

	public boolean isVisible(R recipe) {
		return isUnlocked(recipe);
	}

	@Override
	public void draw(R recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		if(!isUnlocked(recipe)) {
			drawLockedText(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		}
	}

	public void drawLockedText(R recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		class_327 font = font();
		font.method_30883(poseStack, HIDDEN_LINE_1, getWidth() / 2 - font.method_27525(HIDDEN_LINE_1) / 2, getHeight() / 2 - 9, 0x3F3F3F);
		font.method_30883(poseStack, HIDDEN_LINE_2, getWidth() / 2 - font.method_27525(HIDDEN_LINE_2) / 2, getHeight() / 2 + 1, 0x3F3F3F);
	}

	public boolean hasAdvancement(class_2960 advancement) {
		return advancement == null || AdvancementHelper.hasAdvancementClient(advancement);
	}

	public class_327 font() {
		return class_310.method_1551().field_1772;
	}

	public IJeiHelpers jeiHelpers() {
		return SpectrumJEI.jeiHelpers;
	}

	public IPlatformFluidHelper<?> fluidHelper() {
		return jeiHelpers().getPlatformFluidHelper();
	}

	public IGuiHelper guiHelper() {
		return jeiHelpers().getGuiHelper();
	}

	public IIngredientAcceptor<?> addSlot(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, IDrawable background, boolean visible) {
		return visible ? builder.addSlot(ingredientRole, x, y).setBackground(background, 8 - background.getWidth() / 2, 8 - background.getHeight() / 2) : builder.addInvisibleIngredients(ingredientRole);
	}

	public IIngredientAcceptor<?> addSlot(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, boolean visible) {
		return visible ? builder.addSlot(ingredientRole, x, y) : builder.addInvisibleIngredients(ingredientRole);
	}

	public IIngredientAcceptor<?> addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, List<class_1799> itemStacks, IDrawable background, boolean visible) {
		return addSlot(builder, ingredientRole, x, y, background, visible).addItemStacks(itemStacks);
	}

	public IIngredientAcceptor<?> addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, List<class_1799> itemStacks, boolean visible) {
		return addSlot(builder, ingredientRole, x, y, visible).addItemStacks(itemStacks);
	}

	public IIngredientAcceptor<?> addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, class_1856 ingredient, IDrawable background, boolean visible) {
		return addSlot(builder, ingredientRole, x, y, background, visible).addIngredients(ingredient);
	}

	public IIngredientAcceptor<?> addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, class_1856 ingredient, boolean visible) {
		return addSlot(builder, ingredientRole, x, y, visible).addIngredients(ingredient);
	}

	public IIngredientAcceptor<?> addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, class_1799 itemStack, IDrawable background, boolean visible) {
		return addSlot(builder, ingredientRole, x, y, background, visible).addItemStack(itemStack);
	}

	public IIngredientAcceptor<?> addItem(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, class_1799 itemStack, boolean visible) {
		return addSlot(builder, ingredientRole, x, y, visible).addItemStack(itemStack);
	}

	public IIngredientAcceptor<?> addFluid(IRecipeLayoutBuilder builder, RecipeIngredientRole ingredientRole, int x, int y, class_3611 fluid, long amount, IDrawable background, boolean visible) {
		IIngredientAcceptor<?> acceptor = addSlot(builder, ingredientRole, x, y, background, visible).addFluidStack(fluid, amount);
		if(acceptor instanceof IRecipeSlotBuilder slot) {
			slot.setFluidRenderer(amount, false, 16, 16);
		}
		return acceptor;
	}

	public class_2561 getTimeComponent(int time) {
		return time == 20 ? new class_2588("container.spectrum.rei.enchanting.crafting_time_one_second", 1) : new class_2588("container.spectrum.rei.enchanting.crafting_time", time / 20);
	}

	public class_2561 getTimeComponent(int time, float experience) {
		return time == 20 ? new class_2588("container.spectrum.rei.pedestal_crafting.crafting_time_one_second_and_xp", 1, experience) : new class_2588("container.spectrum.rei.pedestal_crafting.crafting_time_and_xp", time / 20, experience);
	}
}
