package thelm.spectrumjei.recipe.category;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on AnvilCrushingEmiRecipeGated
 */
public class AnvilCrushingRecipeCategory extends AbstractGatedRecipeCategory<AnvilCrushingRecipe> {

	public static final class_2561 TITLE = new class_2588("container.spectrum.rei.anvil_crushing.title");

	public static final class_2561 LOW_FORCE = new class_2588("container.spectrum.rei.anvil_crushing.low_force_required");
	public static final class_2561 MEDIUM_FORCE = new class_2588("container.spectrum.rei.anvil_crushing.medium_force_required");
	public static final class_2561 HIGH_FORCE = new class_2588("container.spectrum.rei.anvil_crushing.high_force_required");

	public static final class_2960 BACKGROUND = SpectrumCommon.locate("textures/gui/container/anvil_crushing.png");
	public static final ResourceDrawable WALL = new ResourceDrawable(BACKGROUND, 0, 0, 16, 48);
	public static final ResourceDrawable FALL = new ResourceDrawable(BACKGROUND, 16, 1, 16, 16);

	public AnvilCrushingRecipeCategory() {
		super(SpectrumJEI.ANVIL_CRUSHING, TITLE);
	}

	@Override
	public int getHeight() {
		return 64;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, AnvilCrushingRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		addItem(builder, RecipeIngredientRole.INPUT, 32, 31, recipe.method_8117().get(0), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.CATALYST, 32, 11, new class_1799(class_1802.field_8782), visible);
		addItem(builder, RecipeIngredientRole.OUTPUT, 105, 16, recipe.method_8110(), JEIDrawables.OUTPUT_SLOT, visible);
	}

	@Override
	public void draw(AnvilCrushingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			WALL.draw(poseStack, 10, 1);
			FALL.draw(poseStack, 32, 1);
			JEIDrawables.RECIPE_ARROW.draw(poseStack, 60, 16);
			class_327 font = font();
			class_2561 xpComponent = new class_2588("container.spectrum.rei.anvil_crushing.plus_xp", recipe.getExperience());
			class_2561 forceComponent = getForceComponent(recipe);
			font.method_30883(poseStack, xpComponent, 126 - font.method_27525(xpComponent), 40, 0x3F3F3F);
			font.method_30883(poseStack, forceComponent, getWidth() / 2 - font.method_27525(forceComponent) / 2, 54, 0x3F3F3F);
		}
	}

	public class_2561 getForceComponent(AnvilCrushingRecipe recipe) {
		if(recipe.getCrushedItemsPerPointOfDamage() >= 1F) {
			return LOW_FORCE;
		}
		else if(recipe.getCrushedItemsPerPointOfDamage() >= 0.5F) {
			return MEDIUM_FORCE;
		}
		else {
			return HIGH_FORCE;
		}
	}
}
