package thelm.spectrumjei.recipe.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.spectrumjei.recipe.BlockConversionRecipe;

/**
 * Based on BlockToBlockWithChanceEmiRecipe
 */
public class BlockConversionRecipeCategory extends AbstractUnlockableRecipeCategory<BlockConversionRecipe> {

	public final class_2960 advancement;

	public BlockConversionRecipeCategory(RecipeType<BlockConversionRecipe> recipeType, class_2561 title, class_2960 advancement) {
		super(recipeType, title);
		this.advancement = advancement;
	}

	@Override
	public int getHeight() {
		return 26;
	}

	@Override
	public boolean isUnlocked(BlockConversionRecipe recipe) {
		return hasAdvancement(advancement);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, BlockConversionRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		addSlot(builder, RecipeIngredientRole.INPUT, 30, 5, JEIDrawables.SLOT, visible).addIngredientsUnsafe(recipe.inputIngredient());
		addSlot(builder, RecipeIngredientRole.OUTPUT, 86, 5, JEIDrawables.OUTPUT_SLOT, visible).addIngredientsUnsafe(recipe.outputIngredient());
	}

	@Override
	public void draw(BlockConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			JEIDrawables.RECIPE_ARROW.draw(poseStack, 53, 5);
		}
	}

	@Override
	public class_2960 getRegistryName(BlockConversionRecipe recipe) {
		class_2960 blockKey = class_2378.field_11146.method_10221(recipe.input().method_26204());
		return new class_2960("%s/%s/%s".formatted(recipeType.getUid(), blockKey.method_12836(), blockKey.method_12832()));
	}
}
