package thelm.spectrumjei.recipe.category;

import java.util.List;

import de.dafuqs.spectrum.recipe.cinderhearth.CinderhearthRecipe;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on CinderhearthEmiRecipeGated
 */
public class CinderhearthRecipeCategory extends AbstractGatedRecipeCategory<CinderhearthRecipe> {

	public static final class_2561 TITLE = new class_2588("block.spectrum.cinderhearth");

	public static final IDrawable FLAME = JEIDrawables.flame(10000);

	public CinderhearthRecipeCategory() {
		super(SpectrumJEI.CINDERHEARTH, TITLE);
	}

	@Override
	public int getHeight() {
		return 54;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, CinderhearthRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		addItem(builder, RecipeIngredientRole.INPUT, 4, 1, recipe.method_8117().get(0), JEIDrawables.SLOT, visible);
		List<class_3545<class_1799, Float>> outputs = recipe.getOutputsWithChance();
		for(int i = 0; i < 3; ++i) {
			IIngredientAcceptor<?> acceptor = addSlot(builder, RecipeIngredientRole.OUTPUT, 58 + i * 28, 10, JEIDrawables.OUTPUT_SLOT, visible);
			if(i < outputs.size()) {
				acceptor.addItemStack(outputs.get(i).method_15442());
			}
		}
	}

	@Override
	public void draw(CinderhearthRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			JEIDrawables.recipeArrow(recipe.getCraftingTime() * 50).draw(poseStack, 26, 10);
			FLAME.draw(poseStack, 4, 19);
			class_327 font = font();
			List<class_3545<class_1799, Float>> outputs = recipe.getOutputsWithChance();
			for(int i = 0; i < outputs.size(); ++i) {
				if(outputs.get(i).method_15441() < 1) {
					class_2561 chanceComponent = new class_2585((int)(outputs.get(i).method_15441() * 100) + "%");
					font.method_30883(poseStack, chanceComponent, 67 + i * 28 - font.method_27525(chanceComponent) / 2, 32, 0x3F3F3F);
				}
			}
			class_2561 timeComponent = getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
			font.method_30883(poseStack, timeComponent, getWidth() / 2 - font.method_27525(timeComponent) / 2, 44, 0x3F3F3F);
		}
	}
}
