package thelm.spectrumjei.recipe.category;

import java.util.List;

import de.dafuqs.spectrum.recipe.DescriptiveGatedRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import thelm.jeidrawables.JEIDrawables;

/**
 * Based on IngredientInfoRecipeCategory
 */
public class DescriptiveGatedRecipeCategory<R extends DescriptiveGatedRecipe> extends AbstractGatedRecipeCategory<R> {

	public DescriptiveGatedRecipeCategory(RecipeType<R> recipeType, class_2561 title) {
		super(recipeType, title);
	}

	@Override
	public int getHeight() {
		return 125;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		class_1799 stack = new class_1799(recipe.getItem());
		addItem(builder, RecipeIngredientRole.INPUT, 60, 1, stack, JEIDrawables.SLOT, visible);
		builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(stack);
	}

	@Override
	public void draw(R recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			class_327 font = font();
			List<class_5481> lines = font.method_1728(recipe.getDescription(), getWidth());
			for(int i = 0; i < lines.size(); ++i) {
				font.method_27528(poseStack, lines.get(i), 0, 22 + i * 10, 0x3F3F3F);
			}
		}
	}
}
