package thelm.spectrumjei.recipe.category;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.magic_items.KnowledgeGemItem;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on EnchanterEmiRecipeGated
 */
public class EnchantmentUpgradeRecipeCategory extends AbstractGatedRecipeCategory<EnchantmentUpgradeRecipe> {

	public static final class_2561 TITLE = new class_2588("container.spectrum.rei.enchantment_upgrading.title");

	public static final class_2960 BACKGROUND = SpectrumCommon.locate("textures/gui/container/enchanter.png");
	public static final ResourceDrawable ALTAR = new ResourceDrawable(BACKGROUND, 0, 0, 54, 54);

	public EnchantmentUpgradeRecipeCategory() {
		super(SpectrumJEI.ENCHANTMENT_UPGRADE, TITLE);
	}

	@Override
	public int getHeight() {
		return 80;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, EnchantmentUpgradeRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		class_1792 inputItem = recipe.getRequiredItem();
		int inputCount = recipe.getRequiredItemCount();
		addItem(builder, RecipeIngredientRole.INPUT, 113, 7, KnowledgeGemItem.getKnowledgeDropStackWithXP(recipe.getRequiredExperience(), true), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.CATALYST, 113, 53, new class_1799(SpectrumBlocks.ENCHANTER), visible);
		addItem(builder, RecipeIngredientRole.INPUT, 34, 32, recipe.method_8117().get(0), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 21, 1, new class_1799(inputItem, getSplitCount(inputCount, 0)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 47, 1, new class_1799(inputItem, getSplitCount(inputCount, 1)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 65, 19, new class_1799(inputItem, getSplitCount(inputCount, 2)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 65, 45, new class_1799(inputItem, getSplitCount(inputCount, 3)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 47, 63, new class_1799(inputItem, getSplitCount(inputCount, 4)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 21, 63, new class_1799(inputItem, getSplitCount(inputCount, 5)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 3, 45, new class_1799(inputItem, getSplitCount(inputCount, 6)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 3, 19, new class_1799(inputItem, getSplitCount(inputCount, 7)), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.OUTPUT, 113, 32, recipe.method_8110(), JEIDrawables.OUTPUT_SLOT, visible);
	}

	@Override
	public void draw(EnchantmentUpgradeRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			ALTAR.draw(poseStack, 15, 13);
			JEIDrawables.RECIPE_ARROW.draw(poseStack, 84, 32);
			class_327 font = font();
			class_2561 reqComponent = new class_2588("container.spectrum.rei.enchantment_upgrade.required_item_count", recipe.getRequiredItemCount());
			font.method_30883(poseStack, reqComponent, 69, 70, 0x3F3F3F);
		}
	}

	public int getSplitCount(int inputCount, int index) {
		return inputCount / 8 + (index < inputCount % 8 ? 1 : 0);
	}
}
