package thelm.spectrumjei.recipe.category;

import java.util.List;

import de.dafuqs.spectrum.recipe.fusion_shrine.FusionShrineRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import thelm.jeidrawables.JEIDrawables;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on FusionShrineEmiRecipeGated
 */
public class FusionShrineRecipeCategory extends AbstractGatedRecipeCategory<FusionShrineRecipe> {

	public static final class_2561 TITLE = new class_2588("block.spectrum.fusion_shrine");

	public FusionShrineRecipeCategory() {
		super(SpectrumJEI.FUSION_SHRINE, TITLE);
	}

	@Override
	public int getHeight() {
		return 80;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, FusionShrineRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		if(recipe.getFluidInput() != class_3612.field_15906) {
			addItem(builder, RecipeIngredientRole.CATALYST, 10, 26, new class_1799(SpectrumBlocks.FUSION_SHRINE_BASALT), visible);
			addFluid(builder, RecipeIngredientRole.INPUT, 30, 26, recipe.getFluidInput(), FluidConstants.BUCKET, JEIDrawables.SLOT, visible);
		}
		else {
			addItem(builder, RecipeIngredientRole.CATALYST, 20, 26, new class_1799(SpectrumBlocks.FUSION_SHRINE_BASALT), visible);
		}
		List<IngredientStack> ingredients = recipe.getIngredientStacks();
		int startX = 1 + getWidth() / 2 - ingredients.size() * 9;
		for(int i = 0; i < ingredients.size(); ++i) {
			addItem(builder, RecipeIngredientRole.INPUT, startX + i * 18, 1, ingredients.get(i).getStacks(), JEIDrawables.SLOT, visible);
		}
		addItem(builder, RecipeIngredientRole.OUTPUT, 94, 26, recipe.method_8110(), JEIDrawables.OUTPUT_SLOT, visible);
	}

	@Override
	public void draw(FusionShrineRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			JEIDrawables.recipeArrow(recipe.getCraftingTime() * 50).draw(poseStack, 57, 26);
			class_327 font = font();
			if(recipe.getDescription().isPresent()) {
				List<class_5481> lines = font.method_1728(recipe.getDescription().get(), 136);
				for(int i = 0; i < lines.size(); ++i) {
					font.method_27528(poseStack, lines.get(i), 0, 50 + i * 10, 0x3F3F3F);
				}
			}
			class_2561 timeComponent = getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
			font.method_30883(poseStack, timeComponent, getWidth() / 2 - font.method_27525(timeComponent) / 2, 70, 0x3F3F3F);
		}
	}
}
