package thelm.spectrumjei.recipe.category;

import de.dafuqs.spectrum.recipe.ink_converting.InkConvertingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on InkConvertingEmiRecipeGated
 */
public class InkConvertingRecipeCategory extends AbstractGatedRecipeCategory<InkConvertingRecipe> {

	public static final class_2561 TITLE = new class_2588("container.spectrum.rei.ink_converting.title");

	public InkConvertingRecipeCategory() {
		super(SpectrumJEI.INK_CONVERTING, TITLE);
	}

	@Override
	public int getHeight() {
		return 20;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, InkConvertingRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		addItem(builder, RecipeIngredientRole.INPUT, 1, 2, recipe.method_8117().get(0), JEIDrawables.SLOT, visible);
	}

	@Override
	public void draw(InkConvertingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			JEIDrawables.RECIPE_ARROW.draw(poseStack, 22, 2);
			class_327 font = font();
			class_2561 colorComponent = new class_2588("container.spectrum.rei.ink_converting.color", recipe.getInkColor().getName());
			class_2561 amountComponent = new class_2588("container.spectrum.rei.ink_converting.amount", recipe.getInkAmount());
			font.method_30883(poseStack, colorComponent, 50, 1, 0x3F3F3F);
			font.method_30883(poseStack, amountComponent, 50, 11, 0x3F3F3F);
		}
	}
}
