package thelm.spectrumjei.recipe.category;

import java.util.List;

import de.dafuqs.spectrum.helpers.LoreHelper;
import de.dafuqs.spectrum.recipe.spirit_instiller.SpiritInstillerRecipe;
import de.dafuqs.spectrum.recipe.spirit_instiller.spawner.SpawnerChangeRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on SpiritInstillingEmiRecipeGated
 */
public class SpiritInstillerRecipeCategory extends AbstractGatedRecipeCategory<SpiritInstillerRecipe> {

	public static final class_2561 TITLE = new class_2588("block.spectrum.spirit_instiller");

	public SpiritInstillerRecipeCategory() {
		super(SpectrumJEI.SPIRIT_INSTILLER, TITLE);
	}

	@Override
	public int getHeight() {
		return 48;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, SpiritInstillerRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		List<IngredientStack> ingredients = recipe.getIngredientStacks();
		addItem(builder, RecipeIngredientRole.INPUT, 31, 1, ingredients.get(0).getStacks(), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 11, 1, ingredients.get(1).getStacks(), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.INPUT, 51, 1, ingredients.get(2).getStacks(), JEIDrawables.SLOT, visible);
		addItem(builder, RecipeIngredientRole.CATALYST, 31, 18, new class_1799(SpectrumBlocks.SPIRIT_INSTILLER), visible);
		addItem(builder, RecipeIngredientRole.CATALYST, 11, 18, new class_1799(SpectrumBlocks.ITEM_BOWL_CALCITE), visible);
		addItem(builder, RecipeIngredientRole.CATALYST, 51, 18, new class_1799(SpectrumBlocks.ITEM_BOWL_CALCITE), visible);
		class_1799 stack = recipe.method_8110();
		if(recipe instanceof SpawnerChangeRecipe spawnerChange) {
			LoreHelper.setLore(stack, spawnerChange.getOutputLoreText());
		}
		addItem(builder, RecipeIngredientRole.OUTPUT, 105, 10, stack, JEIDrawables.OUTPUT_SLOT, visible);
	}

	@Override
	public void draw(SpiritInstillerRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			JEIDrawables.recipeArrow(recipe.getCraftingTime() * 50).draw(poseStack, 73, 10);
			class_327 font = font();
			class_2561 timeComponent = getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
			font.method_30883(poseStack, timeComponent, getWidth() / 2 - font.method_27525(timeComponent) / 2, 38, 0x3F3F3F);
		}
	}
}
