package thelm.spectrumjei.recipe.category;

import java.util.List;

import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import thelm.jeidrawables.JEIDrawables;
import thelm.spectrumjei.SpectrumJEI;

/**
 * Based on TitrationBarrelEmiRecipeGated
 */
public class TitrationBarrelRecipeCategory extends AbstractGatedRecipeCategory<ITitrationBarrelRecipe> {

	public static final class_2561 TITLE = new class_2588("block.spectrum.titration_barrel");

	public TitrationBarrelRecipeCategory() {
		super(SpectrumJEI.TITRATION_BARREL, TITLE);
	}

	@Override
	public int getHeight() {
		return 50;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, ITitrationBarrelRecipe recipe, IFocusGroup focuses) {
		boolean visible = isVisible(recipe);
		IPlatformFluidHelper<?> fluidHelper = fluidHelper();
		List<IngredientStack> ingredients = recipe.getIngredientStacks();
		int inputCount = ingredients.size();
		boolean hasFluid = false;
		if(recipe.getFluid() != class_3612.field_15906) {
			inputCount++;
			hasFluid = true;
		}
		int startX = Math.max(11, 41 - inputCount * 10);
		int startY = inputCount > 3 ? 1 : 11;
		if(hasFluid) {
			addFluid(builder, RecipeIngredientRole.INPUT, startX, startY, recipe.getFluid(), fluidHelper.bucketVolume(), JEIDrawables.SLOT, visible);
		}
		for(int i = 0; i < ingredients.size(); ++i) {
			int x = startX + (hasFluid ? i + 1 : i) % 3 * 20;
			int y = startY + (hasFluid ? i + 1 : i) / 3 * 20;
			addItem(builder, RecipeIngredientRole.INPUT, x, y, ingredients.get(i).getStacks(), JEIDrawables.SLOT, visible);
		}
		if(recipe.getTappingItem() != null && recipe.getTappingItem() != class_1802.field_8162) {
			addItem(builder, RecipeIngredientRole.INPUT, 76, 21, new class_1799(recipe.getTappingItem()), JEIDrawables.SLOT, visible);
		}
		addItem(builder, RecipeIngredientRole.OUTPUT, 105, 10, recipe.method_8110(), JEIDrawables.OUTPUT_SLOT, visible);
	}

	@Override
	public void draw(ITitrationBarrelRecipe recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		super.draw(recipe, recipeSlotsView, poseStack, mouseX, mouseY);
		if(isVisible(recipe)) {
			IDrawable recipeArrow = JEIDrawables.recipeArrow(recipe.getMinFermentationTimeHours() * 1000);
			if(recipe.getTappingItem() == null || recipe.getTappingItem() == class_1802.field_8162) {
				recipeArrow.draw(poseStack, 73, 10);
			}
			else {
				recipeArrow.draw(poseStack, 73, 2);
			}
			class_327 font = font();
			class_2561 durationComponent = TitrationBarrelRecipe.getDurationText(recipe.getMinFermentationTimeHours(), recipe.getFermentationData());
			font.method_30883(poseStack, durationComponent, getWidth() / 2 - font.method_27525(durationComponent) / 2, 40, 0x3F3F3F);
		}
	}

}
