/*
 * Decompiled with CFR 0.152.
 */
package com.example.graveplugin;

import com.example.graveplugin.config.PluginConfig;
import com.example.graveplugin.graves.GraveManager;
import com.example.graveplugin.listeners.GraveInteractListener;
import com.example.graveplugin.listeners.PlayerDeathListener;
import com.example.graveplugin.util.BlockChangeApplier;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GravePlugin
extends JavaPlugin {
    private GraveManager graveManager;
    private BlockChangeApplier blockChangeApplier;
    private PluginConfig pluginConfig;

    public void onEnable() {
        this.getLogger().info("GravePlugin has been enabled!");
        this.pluginConfig = new PluginConfig(this);
        this.pluginConfig.loadConfig();
        this.blockChangeApplier = new BlockChangeApplier(this);
        this.graveManager = new GraveManager(this.blockChangeApplier, this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this.graveManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GraveInteractListener(this.graveManager), (Plugin)this);
    }

    public void onDisable() {
        if (this.blockChangeApplier != null) {
            this.blockChangeApplier.cancelAllPending();
        }
        this.getLogger().info("GravePlugin has been disabled!");
    }

    public BlockChangeApplier getBlockChangeApplier() {
        return this.blockChangeApplier;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }
}

