/*
 * Decompiled with CFR 0.152.
 */
package com.example.graveplugin.config;

import com.example.graveplugin.GravePlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class PluginConfig {
    private final GravePlugin plugin;
    private FileConfiguration config;
    private double graveNearbyRadius;
    private String graveBlockType;
    private String graveRemovalBlockType;
    private boolean clearDropsOnDeath;

    public PluginConfig(GravePlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.graveNearbyRadius = this.config.getDouble("grave.nearby-radius", 10.0);
        this.graveBlockType = this.config.getString("grave.block-type", "CHEST");
        this.graveRemovalBlockType = this.config.getString("grave.removal-block-type", "AIR");
        this.clearDropsOnDeath = this.config.getBoolean("grave.clear-drops-on-death", true);
        this.plugin.getLogger().info("Configuration loaded:");
        this.plugin.getLogger().info("  grave.nearby-radius: " + this.graveNearbyRadius);
        this.plugin.getLogger().info("  grave.block-type: " + this.graveBlockType);
        this.plugin.getLogger().info("  grave.removal-block-type: " + this.graveRemovalBlockType);
        this.plugin.getLogger().info("  grave.clear-drops-on-death: " + this.clearDropsOnDeath);
    }

    public double getGraveNearbyRadius() {
        return this.graveNearbyRadius;
    }

    public String getGraveBlockType() {
        return this.graveBlockType;
    }

    public String getGraveRemovalBlockType() {
        return this.graveRemovalBlockType;
    }

    public boolean isClearDropsOnDeath() {
        return this.clearDropsOnDeath;
    }
}

