/*
 * Decompiled with CFR 0.152.
 */
package com.example.graveplugin.graves;

import com.example.graveplugin.GravePlugin;
import com.example.graveplugin.graves.Grave;
import com.example.graveplugin.util.BlockChangeApplier;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GraveManager {
    private final List<Grave> graves = new ArrayList<Grave>();
    private final BlockChangeApplier blockChangeApplier;
    private final GravePlugin plugin;

    public GraveManager(BlockChangeApplier blockChangeApplier, GravePlugin plugin) {
        this.blockChangeApplier = blockChangeApplier;
        this.plugin = plugin;
    }

    public void createGrave(Player player, Location location, List<ItemStack> items) {
        double radius = this.plugin.getPluginConfig().getGraveNearbyRadius();
        Grave nearbyGrave = this.getNearbyGrave(location, radius);
        if (nearbyGrave != null) {
            Block block = nearbyGrave.getLocation().getBlock();
            if (block.getState() instanceof Chest) {
                Chest chest = (Chest)block.getState();
                for (ItemStack item : items) {
                    chest.getInventory().addItem(new ItemStack[]{item});
                }
            }
        } else {
            Material graveBlockType = Material.valueOf((String)this.plugin.getPluginConfig().getGraveBlockType());
            this.blockChangeApplier.addChange(location, graveBlockType);
            this.graves.add(new Grave(player.getUniqueId(), location, items));
        }
    }

    public Grave getGrave(Location location) {
        for (Grave grave : this.graves) {
            if (!grave.getLocation().equals((Object)location)) continue;
            return grave;
        }
        return null;
    }

    public void removeGrave(Grave grave) {
        this.graves.remove(grave);
        Material removalBlockType = Material.valueOf((String)this.plugin.getPluginConfig().getGraveRemovalBlockType());
        this.blockChangeApplier.addChange(grave.getLocation(), removalBlockType);
    }

    private Grave getNearbyGrave(Location location, double radius) {
        for (Grave grave : this.graves) {
            if (!grave.getLocation().getWorld().equals((Object)location.getWorld()) || !(grave.getLocation().distance(location) <= radius)) continue;
            return grave;
        }
        return null;
    }
}

