/*
 * Decompiled with CFR 0.152.
 */
package com.example.graveplugin.util;

import com.example.graveplugin.GravePlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BlockChangeApplier {
    private final GravePlugin plugin;
    private final Map<Location, Material> pendingChanges = new ConcurrentHashMap<Location, Material>();
    private BukkitTask currentTask;
    private final Object lock = new Object();

    public BlockChangeApplier(GravePlugin plugin) {
        this.plugin = plugin;
    }

    public void addChange(Location loc, Material material) {
        this.pendingChanges.put(loc, material);
        this.scheduleBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBatch() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentTask == null || this.currentTask.isCancelled()) {
                this.currentTask = new BukkitRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HashMap changesToApply = new HashMap();
                        Object object = BlockChangeApplier.this.lock;
                        synchronized (object) {
                            changesToApply.putAll(BlockChangeApplier.this.pendingChanges);
                            BlockChangeApplier.this.pendingChanges.clear();
                        }
                        for (Map.Entry entry : changesToApply.entrySet()) {
                            Block block = ((Location)entry.getKey()).getBlock();
                            if (block.getType() == entry.getValue()) continue;
                            block.setType((Material)entry.getValue(), false);
                        }
                        object = BlockChangeApplier.this.lock;
                        synchronized (object) {
                            if (!BlockChangeApplier.this.pendingChanges.isEmpty()) {
                                BlockChangeApplier.this.scheduleBatch();
                            } else {
                                BlockChangeApplier.this.currentTask = null;
                            }
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllPending() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentTask != null && !this.currentTask.isCancelled()) {
                this.currentTask.cancel();
            }
            this.pendingChanges.clear();
            this.currentTask = null;
        }
    }
}

