package net.pneumono.jukebox_looping.mixin;

//? if >=1.21 {
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_9793;
import net.minecraft.class_9794;
import net.pneumono.jukebox_looping.JukeboxLooping;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_9794.class)
public abstract class JukeboxManagerMixin {
    @Shadow
    @Final
    private class_2338 pos;
    @Shadow
    @Nullable
    private class_6880<class_9793> song;

    @Shadow
    public abstract void startPlaying(class_1936 world, class_6880<class_9793> song);

    @WrapOperation(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/block/jukebox/JukeboxManager;stopPlaying(Lnet/minecraft/world/WorldAccess;Lnet/minecraft/block/BlockState;)V"
            )
    )
    public void stopPlayingOrLoop(class_9794 instance, class_1936 world, class_2680 state, Operation<Void> original) {
        if (JukeboxLooping.shouldJukeboxLoop(world, pos)) {
            startPlaying(world, song);
        } else {
            original.call(instance, world, state);
        }
    }
}
//?}
