/*
 * Decompiled with CFR 0.152.
 */
package com.example.SoundOfRain;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SoundOfRainConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue soundRadius;
        public final ForgeConfigSpec.IntValue soundInterval;
        public final ForgeConfigSpec.IntValue maxSoundsPerCycle;
        public final ForgeConfigSpec.BooleanValue debugShowSoundBlock;
        public final ForgeConfigSpec.BooleanValue thunderSounds;
        public final ForgeConfigSpec.BooleanValue enableAmethystRain;
        public final ForgeConfigSpec.BooleanValue enableFabricRain;
        public final ForgeConfigSpec.BooleanValue enableFoliageRain;
        public final ForgeConfigSpec.BooleanValue enableGlassRain;
        public final ForgeConfigSpec.BooleanValue enableMetalRain;
        public final ForgeConfigSpec.BooleanValue enableSandRain;
        public final ForgeConfigSpec.BooleanValue enableWaterRain;
        public final ForgeConfigSpec.BooleanValue enableLavaRain;
        public final ForgeConfigSpec.BooleanValue enableWoodRain;
        public final ForgeConfigSpec.DoubleValue amethystChance;
        public final ForgeConfigSpec.DoubleValue lavaChance;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> amethystTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> amethystBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> fabricTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> fabricBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foliageTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foliageBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> glassTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> glassBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> metalTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> metalBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sandTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sandBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> woodTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> woodBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedMods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedTags;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedBlockNamePatterns;
        public final ForgeConfigSpec.ConfigValue<String> configVersion;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Sound of Rain Configuration");
            builder.comment("20 ticks = 1 second = 1000ms");
            builder.push("sound behaviour");
            this.soundRadius = builder.comment("The radius in blocks that gets checked for blocks.").defineInRange("soundRadius", 15, 1, 32);
            this.soundInterval = builder.comment("Interval in ticks for checking for blocks, starts at the player and goes out in an expanding circle.").defineInRange("soundInterval", 2, 1, 200);
            this.maxSoundsPerCycle = builder.comment("Amount of blocks that will be playing rain sounds per layer.").defineInRange("maxSoundsPerCycle", 2, 1, 64);
            this.debugShowSoundBlock = builder.comment("shows which blocks get scanned, play a sound and provides logs for debugging.").define("debugShowSoundBlock", false);
            builder.push("sound chances");
            builder.comment("Chance for amethyst and lava blocks to chime or sizzle.");
            this.amethystChance = builder.defineInRange("amethystChance", 0.1, 0.0, 1.0);
            this.lavaChance = builder.defineInRange("lavaChance", 0.1, 0.0, 1.0);
            builder.pop();
            builder.push("sound options");
            builder.comment("Enable or disable sounds. Sand sounds awfull, so its disabled by default");
            this.thunderSounds = builder.define("EnableThunderSounds", true);
            this.enableAmethystRain = builder.define("EnableAmethystRain", true);
            this.enableFabricRain = builder.define("EnableFabricRain", true);
            this.enableFoliageRain = builder.define("EnableFoliageRain", true);
            this.enableGlassRain = builder.define("EnableGlassRain", true);
            this.enableMetalRain = builder.define("EnableMetalRain", true);
            this.enableSandRain = builder.define("EnableSandRain", false);
            this.enableWoodRain = builder.define("EnableWoodRain", true);
            this.enableWaterRain = builder.define("EnableWaterRain", true);
            this.enableLavaRain = builder.define("EnableLavaRain", true);
            builder.pop();
            builder.push("material rain sound blocks");
            builder.comment("you can add block id's and tags here. Some blocks are backed by their sound types");
            this.amethystTags = builder.comment("Tags/Id's for Amethyst like blocks").defineList("amethystTags", List.of(""), o -> o instanceof String);
            this.amethystBlocks = builder.defineList("amethystBlocks", List.of(""), o -> o instanceof String);
            this.fabricTags = builder.comment("Tags/Id's for Fabric blocks").defineList("fabricTags", List.of("#minecraft:wool", "#minecraft:wool_carpet", "#minecraft:beds", "#minecraft:banners"), o -> o instanceof String);
            this.fabricBlocks = builder.defineList("fabricBlocks", List.of(""), o -> o instanceof String);
            this.foliageTags = builder.comment("Tags/Id's for Foliage blocks").defineList("foliageTags", List.of("#minecraft:leaves", "#minecraft:flowers"), o -> o instanceof String);
            this.foliageBlocks = builder.defineList("foliageBlocks", List.of(""), o -> o instanceof String);
            this.glassTags = builder.comment("Tags/Id's for Glass blocks").defineList("glassTags", List.of("#forge:glass", "#forge:glass_panes"), o -> o instanceof String);
            this.glassBlocks = builder.defineList("glassBlocks", List.of(""), o -> o instanceof String);
            this.metalTags = builder.comment("Tags/Id's for Metal blocks").defineList("metalTags", List.of("#minecraft:beacon_base_blocks", "#minecraft:anvil"), o -> o instanceof String);
            this.metalBlocks = builder.defineList("metalBlocks", List.of("minecraft:cauldron", "minecraft:hopper"), o -> o instanceof String);
            this.sandTags = builder.comment("Tags/Id's for Sand blocks").defineList("sandTags", List.of("#minecraft:sand"), o -> o instanceof String);
            this.sandBlocks = builder.defineList("sandBlocks", List.of(""), o -> o instanceof String);
            this.woodTags = builder.comment("Tags/Id's for Wood blocks").defineList("woodTags", List.of("#minecraft:logs", "#minecraft:wooden_stairs", "#minecraft:planks", "#minecraft:wooden_slabs", "#minecraft:wooden_fences", "#minecraft:wooden_doors", "#minecraft:wooden_trapdoors", "#minecraft:wooden_pressure_plates", "#minecraft:wooden_buttons"), o -> o instanceof String);
            this.woodBlocks = builder.defineList("woodBlocks", List.of(""), o -> o instanceof String);
            builder.pop();
            builder.push("The blacklist");
            this.blacklistedMods = builder.comment("Blacklist entire mods by their namespace (e.g., \"modname\")").defineList("blacklistedMods", List.of("copycats"), o -> o instanceof String);
            this.blacklistedTags = builder.comment("Blacklist entire tags by their ID (e.g., \"#minecraft:leaves\")").defineList("blacklistedTags", List.of(""), o -> o instanceof String);
            this.blacklistedBlocks = builder.comment("Blacklist specific block IDs (e.g., \"minecraft:dirt\"").defineList("blacklistedBlocks", List.of(""), o -> o instanceof String);
            this.blacklistedBlockNamePatterns = builder.comment("Blacklist blocks by name pattern - blocks containing these strings will be skipped (e.g., \"terracotta\"").defineList("blacklistedBlockNamePatterns", List.of("Copycat"), o -> o instanceof String);
            builder.pop();
            this.configVersion = builder.comment("Config version - do not modify").define("configVersion", (Object)"0.4.0");
        }
    }
}

