/*
 * Decompiled with CFR 0.152.
 */
package com.example.SoundOfRain.materialsound;

import com.example.SoundOfRain.SoundOfRainConfig;
import com.example.SoundOfRain.SoundRegistry;
import com.example.SoundOfRain.materialsound.MaterialRainSoundRegister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class MaterialRainSoundHandler {
    private static final Random RANDOM = new Random();
    private static final float BASE_VOLUME = 1.0f;
    private static final float MIN_VOLUME = 0.3f;
    private static final float MAX_VOLUME = 1.0f;
    private static final float MIN_PITCH = 0.9f;
    private static final float PITCH_VARIANCE = 0.3f;
    private static final float MIN_PITCH_INDOORS = 0.65f;
    private static final float PITCH_VARIANCE_INDOORS = 0.2f;
    private static final int SKY_CHECK_HEIGHT = 5;
    private static final Map<MaterialSoundType, SoundEvent> SOUND_CACHE = new EnumMap<MaterialSoundType, SoundEvent>(MaterialSoundType.class);
    private int currentScanDistance = 0;
    private int nextSoundInterval = 0;
    private boolean isRaining = false;
    private boolean wasRaining = false;
    private final Map<BlockPos, Long> lastSoundTime = new HashMap<BlockPos, Long>();
    private final Map<BlockPos, Integer> soundCooldownOffset = new HashMap<BlockPos, Integer>();
    private final Set<BlockPos> debugParticles = new HashSet<BlockPos>();
    private final Queue<ScheduledSound> scheduledSounds = new LinkedList<ScheduledSound>();
    private int blockScans = 0;
    private int lastCandidatesFound = 0;

    private static int SOUND_RADIUS() {
        return (Integer)SoundOfRainConfig.CLIENT.soundRadius.get();
    }

    private static int SOUND_INTERVAL() {
        return (Integer)SoundOfRainConfig.CLIENT.soundInterval.get();
    }

    private static int MAX_SOUNDS_PER_CYCLE() {
        return (Integer)SoundOfRainConfig.CLIENT.maxSoundsPerCycle.get();
    }

    private boolean isValidBlockPos(Level level, BlockPos pos) {
        int y = pos.m_123342_();
        return y >= level.m_141937_() && y < level.m_151558_() && level.m_46749_(pos);
    }

    public static void initSoundCache() {
        MaterialRainSoundRegister.loadBlacklistsFromConfig();
        int cached = 0;
        if (SoundRegistry.RAIN_AMETHYST.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.AMETHYST, (SoundEvent)SoundRegistry.RAIN_AMETHYST.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_FABRIC.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.FABRIC, (SoundEvent)SoundRegistry.RAIN_FABRIC.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_FOLIAGE.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.FOLIAGE, (SoundEvent)SoundRegistry.RAIN_FOLIAGE.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_GLASS.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.GLASS, (SoundEvent)SoundRegistry.RAIN_GLASS.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_METAL.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.METAL, (SoundEvent)SoundRegistry.RAIN_METAL.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_SAND.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.SAND, (SoundEvent)SoundRegistry.RAIN_SAND.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_WOOD.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.WOOD, (SoundEvent)SoundRegistry.RAIN_WOOD.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_WATER.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.WATER, (SoundEvent)SoundRegistry.RAIN_WATER.get());
            ++cached;
        }
        if (SoundRegistry.RAIN_LAVA.isPresent()) {
            SOUND_CACHE.put(MaterialSoundType.LAVA, (SoundEvent)SoundRegistry.RAIN_LAVA.get());
            ++cached;
        }
        System.out.println("[SoundOfRain] MaterialRainSoundHandler.initSoundCache: Cached " + cached + " material rain sounds: " + SOUND_CACHE.keySet());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.m_91104_()) {
            return;
        }
        this.isRaining = mc.f_91073_.m_46471_();
        if (!this.isRaining && this.wasRaining) {
            this.lastSoundTime.clear();
            this.nextSoundInterval = 0;
            this.currentScanDistance = 0;
        }
        this.wasRaining = this.isRaining;
        if (this.isRaining) {
            if (this.nextSoundInterval <= 0) {
                this.playMaterialSounds(mc);
                this.nextSoundInterval = MaterialRainSoundHandler.SOUND_INTERVAL();
                this.blockScans = 0;
            } else {
                --this.nextSoundInterval;
            }
        }
        long now = System.currentTimeMillis();
        while (!this.scheduledSounds.isEmpty() && this.scheduledSounds.peek().playTimeMs <= now) {
            ScheduledSound ss = this.scheduledSounds.poll();
            this.playSound(mc, ss.pos, ss.soundType, ss.playerPos);
        }
    }

    private void playMaterialSounds(Minecraft mc) {
        if (mc == null || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        BlockPos playerPos = mc.f_91074_.m_20183_();
        long currentTime = System.currentTimeMillis();
        List<SoundCandidate> candidates = this.findSoundCandidatesExpandingCircle(mc, playerPos, currentTime);
        this.lastCandidatesFound = candidates.size();
        if (candidates.isEmpty()) {
            return;
        }
        int soundsPlayed = this.playSelectedSounds(mc, candidates, playerPos, currentTime);
        if (((Boolean)SoundOfRainConfig.CLIENT.debugShowSoundBlock.get()).booleanValue()) {
            System.out.println("[SoundOfRain] blocks scanned: " + this.blockScans + " | candidates found: " + this.lastCandidatesFound + " | sounds playing: " + soundsPlayed);
        }
    }

    private List<SoundCandidate> findSoundCandidatesExpandingCircle(Minecraft mc, BlockPos playerPos, long currentTime) {
        ArrayList<SoundCandidate> candidates = new ArrayList<SoundCandidate>();
        int radius = MaterialRainSoundHandler.SOUND_RADIUS();
        boolean debugEnabled = (Boolean)SoundOfRainConfig.CLIENT.debugShowSoundBlock.get();
        int scanDistance = this.currentScanDistance;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -6; y <= 6; ++y) {
                    MaterialSoundType soundType;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    int dist = Math.abs(x) + Math.abs(z) + Math.abs(y);
                    BlockState state = mc.f_91073_.m_8055_(checkPos);
                    if (state.m_60795_() || MaterialRainSoundRegister.isBlockBlacklisted(state.m_60734_()) || !this.isScannableBlock(state.m_60734_()) || dist != scanDistance) continue;
                    if (debugEnabled && mc.f_91073_ != null) {
                        mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, (double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 1.0, (double)checkPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    }
                    if ((soundType = this.getSoundType(state.m_60734_())) == null) continue;
                    if (debugEnabled) {
                        ++this.blockScans;
                    }
                    if (soundType == MaterialSoundType.AMETHYST && RANDOM.nextDouble() > (Double)SoundOfRainConfig.CLIENT.amethystChance.get() || soundType == MaterialSoundType.LAVA && RANDOM.nextDouble() > (Double)SoundOfRainConfig.CLIENT.lavaChance.get() || !this.canPlaySound(mc, checkPos, currentTime)) continue;
                    candidates.add(new SoundCandidate(checkPos, soundType));
                }
            }
        }
        ++this.currentScanDistance;
        if (this.currentScanDistance > radius) {
            this.currentScanDistance = 0;
        }
        return candidates;
    }

    private int playSelectedSounds(Minecraft mc, List<SoundCandidate> candidates, BlockPos playerPos, long currentTime) {
        HashSet<MaterialSoundType> playedTypes = new HashSet<MaterialSoundType>();
        HashSet<BlockPos> usedPositions = new HashSet<BlockPos>();
        int soundsPlayed = 0;
        Collections.shuffle(candidates, RANDOM);
        long nextPlayTime = System.currentTimeMillis();
        int minSpacingMs = 100;
        for (SoundCandidate candidate : candidates) {
            boolean isNewType;
            if (soundsPlayed >= MaterialRainSoundHandler.MAX_SOUNDS_PER_CYCLE()) break;
            if (usedPositions.contains(candidate.pos)) continue;
            Long lastTime = this.lastSoundTime.get(candidate.pos);
            int offset = this.soundCooldownOffset.computeIfAbsent(candidate.pos, p -> RANDOM.nextInt(100));
            long cooldown = offset;
            if (lastTime != null && currentTime - lastTime < cooldown) continue;
            boolean bl = isNewType = !playedTypes.contains((Object)candidate.soundType);
            if (soundsPlayed < MaterialRainSoundHandler.MAX_SOUNDS_PER_CYCLE() / 2 && !isNewType) continue;
            int delay = (int)(nextPlayTime - System.currentTimeMillis()) + 100;
            if (delay < 0) {
                delay = 100;
            }
            if (candidate.soundType == MaterialSoundType.AMETHYST || candidate.soundType == MaterialSoundType.LAVA) {
                delay += RANDOM.nextInt(500) + 100;
            }
            this.schedulePlaySound(mc, candidate.pos, candidate.soundType, playerPos, delay);
            this.lastSoundTime.put(candidate.pos, currentTime + (long)delay);
            usedPositions.add(candidate.pos);
            if (isNewType) {
                playedTypes.add(candidate.soundType);
            }
            ++soundsPlayed;
            nextPlayTime += 100L;
        }
        return soundsPlayed;
    }

    private void schedulePlaySound(Minecraft mc, BlockPos pos, MaterialSoundType soundType, BlockPos playerPos, int delayMs) {
        long playTime = System.currentTimeMillis() + (long)delayMs;
        this.scheduledSounds.add(new ScheduledSound(pos, soundType, playerPos, playTime));
    }

    private MaterialSoundType getSoundType(Block block) {
        MaterialSoundType soundType = MaterialRainSoundRegister.getSoundType(block);
        if (soundType != null && this.isMaterialEnabled(soundType)) {
            return soundType;
        }
        MaterialSoundType fallbackType = this.getSoundTypeFromBlockProperties(block);
        if (fallbackType != null && this.isMaterialEnabled(fallbackType)) {
            return fallbackType;
        }
        return null;
    }

    private boolean isMaterialEnabled(MaterialSoundType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MaterialSoundType.AMETHYST -> (Boolean)SoundOfRainConfig.CLIENT.enableAmethystRain.get();
            case MaterialSoundType.FABRIC -> (Boolean)SoundOfRainConfig.CLIENT.enableFabricRain.get();
            case MaterialSoundType.FOLIAGE -> (Boolean)SoundOfRainConfig.CLIENT.enableFoliageRain.get();
            case MaterialSoundType.GLASS -> (Boolean)SoundOfRainConfig.CLIENT.enableGlassRain.get();
            case MaterialSoundType.METAL -> (Boolean)SoundOfRainConfig.CLIENT.enableMetalRain.get();
            case MaterialSoundType.SAND -> (Boolean)SoundOfRainConfig.CLIENT.enableSandRain.get();
            case MaterialSoundType.WOOD -> (Boolean)SoundOfRainConfig.CLIENT.enableWoodRain.get();
            case MaterialSoundType.WATER -> (Boolean)SoundOfRainConfig.CLIENT.enableWaterRain.get();
            case MaterialSoundType.LAVA -> (Boolean)SoundOfRainConfig.CLIENT.enableLavaRain.get();
        };
    }

    private MaterialSoundType getSoundTypeFromBlockProperties(Block block) {
        SoundType soundType = block.m_49966_().m_60827_();
        if (block.m_49966_().m_60795_()) {
            return null;
        }
        if (soundType == SoundType.f_56744_) {
            return MaterialSoundType.GLASS;
        }
        if (soundType == SoundType.f_56743_ || soundType == SoundType.f_56749_ || soundType == SoundType.f_56728_ || soundType == SoundType.f_154663_ || soundType == SoundType.f_56762_) {
            return MaterialSoundType.METAL;
        }
        if (soundType == SoundType.f_154674_ || soundType == SoundType.f_271239_ || soundType == SoundType.f_56758_ || soundType == SoundType.f_56757_) {
            return MaterialSoundType.FOLIAGE;
        }
        if (soundType == SoundType.f_56745_) {
            return MaterialSoundType.FABRIC;
        }
        if (soundType == SoundType.f_154654_ || soundType == SoundType.f_154655_ || soundType == SoundType.f_154658_ || soundType == SoundType.f_154657_ || soundType == SoundType.f_154656_) {
            return MaterialSoundType.AMETHYST;
        }
        if (soundType == SoundType.f_56746_) {
            return MaterialSoundType.SAND;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId != null) {
            String id = blockId.toString();
            if (id.equals("minecraft:water")) {
                return MaterialSoundType.WATER;
            }
            if (id.equals("minecraft:lava")) {
                return MaterialSoundType.LAVA;
            }
        }
        return null;
    }

    private boolean isScannableBlock(Block block) {
        if (MaterialRainSoundRegister.getSoundType(block) != null) {
            return true;
        }
        return this.getSoundTypeFromBlockProperties(block) != null;
    }

    private boolean canPlaySound(Minecraft mc, BlockPos pos, long currentTime) {
        Long lastTime = this.lastSoundTime.get(pos);
        if (lastTime != null && currentTime - lastTime < 1500L) {
            return false;
        }
        return this.isExposedToRain(mc, pos);
    }

    private boolean isExposedToRain(Minecraft mc, BlockPos pos) {
        if (this.hasTopExposure(mc, pos)) {
            return true;
        }
        return this.hasSideExposure(mc, pos);
    }

    private boolean blocksRain(BlockState state, Minecraft mc, BlockPos pos) {
        if (mc == null || mc.f_91073_ == null) {
            return false;
        }
        ClientLevel level = mc.f_91073_;
        int skyHeight = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        return pos.m_123342_() < skyHeight;
    }

    private boolean hasTopExposure(Minecraft mc, BlockPos pos) {
        if (mc == null || mc.f_91073_ == null) {
            return false;
        }
        ClientLevel level = mc.f_91073_;
        boolean clearPathFound = false;
        for (int y = 1; y <= 5; ++y) {
            BlockPos above = pos.m_6630_(y);
            BlockState state = level.m_8055_(above);
            if (!this.isValidBlockPos((Level)level, above)) {
                return false;
            }
            if (this.blocksRain(state, mc, above)) {
                return false;
            }
            if (!level.m_45527_(above)) continue;
            clearPathFound = true;
        }
        return clearPathFound;
    }

    private boolean hasSideExposure(Minecraft mc, BlockPos pos) {
        if (mc == null || mc.f_91073_ == null) {
            return false;
        }
        ClientLevel level = mc.f_91073_;
        BlockPos[] directions = new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_()};
        MaterialSoundType thisType = this.getSoundType(level.m_8055_(pos).m_60734_());
        for (BlockPos sidePos : directions) {
            BlockState aboveState;
            BlockPos aboveSide;
            int y;
            if (!this.isValidBlockPos((Level)level, pos)) continue;
            BlockState sideState = level.m_8055_(sidePos);
            if (thisType == MaterialSoundType.GLASS) {
                BlockState furtherState;
                if (!this.blocksRain(sideState, mc, sidePos)) {
                    boolean blockedAbove = false;
                    for (y = 1; y <= 5; ++y) {
                        aboveSide = sidePos.m_6630_(y);
                        aboveState = level.m_8055_(aboveSide);
                        if (this.blocksRain(aboveState, mc, aboveSide)) {
                            blockedAbove = true;
                            break;
                        }
                        if (!level.m_45527_(aboveSide)) continue;
                        return true;
                    }
                    if (!blockedAbove && this.isConnectedToSky(mc, sidePos)) {
                        return true;
                    }
                }
                Direction dir = null;
                if (sidePos.m_123341_() > pos.m_123341_()) {
                    dir = Direction.EAST;
                } else if (sidePos.m_123341_() < pos.m_123341_()) {
                    dir = Direction.WEST;
                } else if (sidePos.m_123343_() > pos.m_123343_()) {
                    dir = Direction.SOUTH;
                } else if (sidePos.m_123343_() < pos.m_123343_()) {
                    dir = Direction.NORTH;
                }
                if (dir == null) continue;
                BlockPos furtherSide = sidePos.m_121945_(dir);
                if (!this.isValidBlockPos((Level)level, pos) || this.blocksRain(furtherState = level.m_8055_(furtherSide), mc, furtherSide)) continue;
                boolean blockedFurtherAbove = false;
                for (int y2 = 1; y2 <= 5; ++y2) {
                    BlockPos aboveFurther = furtherSide.m_6630_(y2);
                    BlockState aboveFurtherState = level.m_8055_(aboveFurther);
                    if (this.blocksRain(aboveFurtherState, mc, aboveFurther)) {
                        blockedFurtherAbove = true;
                        break;
                    }
                    if (!level.m_45527_(aboveFurther)) continue;
                    return true;
                }
                if (blockedFurtherAbove || !this.isConnectedToSky(mc, furtherSide)) continue;
                return true;
            }
            if (this.blocksRain(sideState, mc, sidePos)) continue;
            boolean blockedAbove = false;
            for (y = 1; y <= 5; ++y) {
                aboveSide = sidePos.m_6630_(y);
                aboveState = level.m_8055_(aboveSide);
                if (this.blocksRain(aboveState, mc, aboveSide)) {
                    blockedAbove = true;
                    break;
                }
                if (!level.m_45527_(aboveSide)) continue;
                return true;
            }
            if (blockedAbove || this.blocksRain(sideState, mc, sidePos) || !this.isConnectedToSky(mc, sidePos)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectedToSky(Minecraft mc, BlockPos pos) {
        if (mc == null || mc.f_91073_ == null) {
            return false;
        }
        ClientLevel level = mc.f_91073_;
        for (int y = 1; y <= 5; ++y) {
            BlockPos checkPos = pos.m_6630_(y);
            if (!this.isValidBlockPos((Level)level, pos)) {
                return false;
            }
            if (level.m_45527_(checkPos)) {
                return true;
            }
            BlockState blockState = level.m_8055_(checkPos);
            if (!this.blocksRain(blockState, mc, checkPos)) continue;
            return false;
        }
        return false;
    }

    private void playSound(Minecraft mc, BlockPos pos, MaterialSoundType soundType, BlockPos playerPos) {
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        if (!this.canRainAt(mc, pos)) {
            return;
        }
        SoundEvent soundEvent = this.getSoundEvent(soundType);
        if (soundEvent == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        double distance = Math.sqrt(pos.m_123331_((Vec3i)playerPos));
        float volume = 1.0f * (1.0f - (float)(distance / (double)MaterialRainSoundHandler.SOUND_RADIUS()));
        volume = Math.max(0.3f, Math.min(1.0f, volume));
        boolean indoors = this.isPlayerIndoors(mc, playerPos);
        if (indoors) {
            volume *= 0.5f;
        }
        float pitch = indoors ? 0.65f + RANDOM.nextFloat() * 0.2f : 0.9f + RANDOM.nextFloat() * 0.3f;
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.WEATHER, volume *= mc.f_91066_.m_92147_(SoundSource.WEATHER), pitch, false);
        if (((Boolean)SoundOfRainConfig.CLIENT.debugShowSoundBlock.get()).booleanValue()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            this.debugParticles.add(pos.m_7949_());
        }
    }

    private SoundEvent getSoundEvent(MaterialSoundType soundType) {
        SoundEvent event = SOUND_CACHE.get((Object)soundType);
        if (event == null) {
            return null;
        }
        return event;
    }

    private boolean isPlayerIndoors(Minecraft mc, BlockPos playerPos) {
        if (mc == null || mc.f_91073_ == null) {
            return true;
        }
        ClientLevel level = mc.f_91073_;
        if (playerPos.m_123342_() < level.m_141937_()) {
            return true;
        }
        BlockPos headPos = playerPos.m_7494_();
        if (level.m_45527_(headPos)) {
            return false;
        }
        int skyExposure = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos checkPos = headPos.m_7918_(x, 0, z);
                if (!level.m_45527_(checkPos)) continue;
                ++skyExposure;
            }
        }
        return skyExposure < 3;
    }

    public void shutdown() {
        this.lastSoundTime.clear();
        this.soundCooldownOffset.clear();
    }

    private boolean canRainAt(Minecraft mc, BlockPos pos) {
        if (mc == null || mc.f_91073_ == null) {
            return false;
        }
        Biome biome = (Biome)mc.f_91073_.m_204166_(pos).m_203334_();
        return biome.m_264600_(pos) == Biome.Precipitation.RAIN;
    }

    public static enum MaterialSoundType {
        AMETHYST("amethyst"),
        FABRIC("fabric"),
        FOLIAGE("foliage"),
        GLASS("glass"),
        METAL("metal"),
        SAND("sand"),
        WOOD("wood"),
        WATER("water"),
        LAVA("lava");

        private final String name;

        private MaterialSoundType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ScheduledSound {
        final BlockPos pos;
        final MaterialSoundType soundType;
        final BlockPos playerPos;
        final long playTimeMs;

        ScheduledSound(BlockPos pos, MaterialSoundType soundType, BlockPos playerPos, long playTimeMs) {
            this.pos = pos;
            this.soundType = soundType;
            this.playerPos = playerPos;
            this.playTimeMs = playTimeMs;
        }
    }

    private static class SoundCandidate {
        final BlockPos pos;
        final MaterialSoundType soundType;

        SoundCandidate(BlockPos pos, MaterialSoundType soundType) {
            this.pos = pos;
            this.soundType = soundType;
        }
    }
}

