/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd;

import com.ferrum.todd.TODDCommand;
import com.ferrum.todd.block.TODDBlocks;
import com.ferrum.todd.block.TODDStoneBlocks;
import com.ferrum.todd.effect.FoodComaStatusEffect;
import com.ferrum.todd.effect.HallucinationStatusEffect;
import com.ferrum.todd.effect.StarvationStatusEffect;
import com.ferrum.todd.entity.TODDEntities;
import com.ferrum.todd.item.FrictionFireKitItem;
import com.ferrum.todd.item.SharpStickItem;
import com.ferrum.todd.item.ShortSharpStickItem;
import com.ferrum.todd.item.TODDCreativeTabs;
import com.ferrum.todd.item.TODDItems;
import com.ferrum.todd.starvation.StarvationEffectManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TODDMod
implements ModInitializer {
    public static final String MOD_ID = "todd";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"todd");
    public static final StarvationStatusEffect STARVATION_EFFECT = new StarvationStatusEffect();
    public static final HallucinationStatusEffect HALLUCINATION_EFFECT = new HallucinationStatusEffect();
    public static final FoodComaStatusEffect FOOD_COMA_EFFECT = new FoodComaStatusEffect();

    public void onInitialize() {
        LOGGER.info("The Obscure & Difficult Dawn mod initialized!");
        this.registerStatusEffects();
        StarvationEffectManager.setStarvationEffect(STARVATION_EFFECT);
        StarvationEffectManager.setFoodComaEffect(FOOD_COMA_EFFECT);
        TODDItems.registerItems();
        TODDStoneBlocks.registerBlocks();
        TODDCreativeTabs.registerCreativeTabs();
        TODDCommand.register();
        this.disableVanillaAdvancements();
        TODDBlocks.registerBlocks();
        SharpStickItem.registerModelPredicate();
        ShortSharpStickItem.registerModelPredicate();
        this.registerRecipes();
        TODDEntities.initialize();
        class_5272.method_27879((class_1792)TODDItems.FRICTION_FIRE_KIT, (class_2960)new class_2960(MOD_ID, "animation_frame"), (stack, world, entity, seed) -> FrictionFireKitItem.getAnimationFrame(stack));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> LOGGER.info("TODD difficulty system ready!"));
    }

    private void disableVanillaAdvancements() {
        LOGGER.info("Vanilla advancements disabled");
    }

    private void registerStatusEffects() {
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"starvation"), (Object)((Object)STARVATION_EFFECT));
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"hallucination"), (Object)((Object)HALLUCINATION_EFFECT));
        class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"food_coma"), (Object)((Object)FOOD_COMA_EFFECT));
        LOGGER.info("Registered custom status effects");
    }

    private void registerRecipes() {
        LOGGER.info("TODD recipes system initialized");
    }
}

