/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.block;

import com.ferrum.todd.TODDMod;
import com.ferrum.todd.item.FlintKnifeItem;
import com.ferrum.todd.item.TODDItems;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class TODDStoneBlocks {
    public static final class_2746 HAS_ITEM = class_2746.method_11825((String)"has_item");
    public static final class_2754<ItemType> ITEM_TYPE = class_2754.method_11850((String)"item_type", ItemType.class);
    private static final Map<class_2338, ProcessingData> processingData = new HashMap<class_2338, ProcessingData>();
    public static final class_2248 FLAT_STONE = new FlatStoneBlock((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10340).strength(1.0f, 3.0f).sounds(class_2498.field_11544).nonOpaque());

    public static void forceCompleteProcessing(class_2338 pos, class_1657 player) {
        ProcessingData data = processingData.get(pos);
        if (data != null && data.player != null) {
            class_1937 world = player.method_37908();
            class_2680 state = world.method_8320(pos);
            TODDStoneBlocks.completeLeatherProcessing(world, pos, data.player, data.processType);
            TODDMod.LOGGER.info("Forced completion of leather processing at " + String.valueOf(pos));
        }
    }

    public static ProcessType getProcessType(class_2338 pos) {
        ProcessingData data = processingData.get(pos);
        return data != null ? data.processType : null;
    }

    public static void completeLeatherProcessing(class_1937 world, class_2338 pos, class_1657 player, ProcessType processType) {
        class_1799 resultItem;
        switch (processType.ordinal()) {
            case 0: {
                resultItem = new class_1799((class_1935)TODDItems.SCRAPED_LEATHER);
                TODDStoneBlocks.damageSharpSticks(player, world.field_9229);
                break;
            }
            case 1: {
                resultItem = new class_1799((class_1935)TODDItems.PROCESSED_LEATHER);
                TODDStoneBlocks.damagePlayerKnives(player, world.field_9229);
                break;
            }
            default: {
                resultItem = class_1799.field_8037;
            }
        }
        if (!resultItem.method_7960() && !player.method_7337()) {
            player.method_7270(resultItem);
        }
        world.method_8652(pos, FLAT_STONE.method_9564(), 3);
        world.method_8396(null, pos, class_3417.field_14709, class_3419.field_15245, 0.8f, 1.2f);
        if (world.field_9236) {
            TODDStoneBlocks.spawnCompletionParticles(world, pos);
        }
        processingData.remove(pos);
        TODDMod.LOGGER.info("Leather processing completed: " + String.valueOf((Object)processType) + " at " + String.valueOf(pos));
    }

    private static void damageSharpSticks(class_1657 player, class_5819 random) {
        class_1799 offHand;
        int damageAmount = random.method_43048(6) + 1;
        class_1799 mainHand = player.method_6047();
        if ((mainHand.method_31574(TODDItems.SHARP_STICK) || mainHand.method_31574(TODDItems.SHORT_SHARP_STICK)) && mainHand.method_7963()) {
            for (int i = 0; i < damageAmount; ++i) {
                mainHand.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            }
            TODDMod.LOGGER.info("Damaged sharp stick in main hand by " + damageAmount);
        }
        if (((offHand = player.method_6079()).method_31574(TODDItems.SHARP_STICK) || offHand.method_31574(TODDItems.SHORT_SHARP_STICK)) && offHand.method_7963()) {
            for (int i = 0; i < damageAmount; ++i) {
                offHand.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5810));
            }
            TODDMod.LOGGER.info("Damaged sharp stick in off hand by " + damageAmount);
        }
    }

    private static void damagePlayerKnives(class_1657 player, class_5819 random) {
        class_1799 offHand;
        int damageAmount = random.method_43048(6) + 1;
        class_1799 mainHand = player.method_6047();
        if (mainHand.method_7909() instanceof FlintKnifeItem && mainHand.method_7963()) {
            for (int i = 0; i < damageAmount; ++i) {
                mainHand.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            }
            TODDMod.LOGGER.info("Damaged knife in main hand by " + damageAmount);
        }
        if ((offHand = player.method_6079()).method_7909() instanceof FlintKnifeItem && offHand.method_7963()) {
            for (int i = 0; i < damageAmount; ++i) {
                offHand.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5810));
            }
            TODDMod.LOGGER.info("Damaged knife in off hand by " + damageAmount);
        }
    }

    private static void spawnCompletionParticles(class_1937 world, class_2338 pos) {
        for (int i = 0; i < 10; ++i) {
            world.method_8406((class_2394)class_2398.field_11211, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, world.field_9229.method_43059() * 0.1, 0.2, world.field_9229.method_43059() * 0.1);
        }
    }

    public static Long getProcessingTimer(class_2338 pos) {
        ProcessingData data = processingData.get(pos);
        return data != null ? Long.valueOf(data.startTime) : null;
    }

    public static boolean isProcessing(class_2338 pos) {
        return processingData.containsKey(pos);
    }

    public static void cancelProcessing(class_2338 pos) {
        processingData.remove(pos);
    }

    public static void registerBlocks() {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_43902((String)"todd", (String)"flat_stone"), (Object)FLAT_STONE);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_43902((String)"todd", (String)"flat_stone"), (Object)new class_1747(FLAT_STONE, (class_1792.class_1793)new FabricItemSettings()));
        TODDMod.LOGGER.info("TODD stone blocks registered");
    }

    private static class ProcessingData {
        public final long startTime;
        public final class_1657 player;
        public final ProcessType processType;

        public ProcessingData(long startTime, class_1657 player, ProcessType processType) {
            this.startTime = startTime;
            this.player = player;
            this.processType = processType;
        }
    }

    public static enum ProcessType {
        SCRAPING_RAW_LEATHER,
        PROCESSING_TANNED_LEATHER;

    }

    public static enum ItemType implements class_3542
    {
        NONE("none"),
        RAW_LEATHER("raw_leather"),
        TANNED_LEATHER("tanned_leather");

        private final String name;

        private ItemType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class FlatStoneBlock
    extends class_2248 {
        public FlatStoneBlock(class_4970.class_2251 settings) {
            super(settings);
            this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)HAS_ITEM, (Comparable)Boolean.valueOf(false))).method_11657(ITEM_TYPE, (Comparable)((Object)ItemType.NONE)));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            builder.method_11667(new class_2769[]{HAS_ITEM, ITEM_TYPE});
        }

        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        }

        public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        }

        public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            class_1799 heldItem = player.method_5998(hand);
            if (!((Boolean)state.method_11654((class_2769)HAS_ITEM)).booleanValue()) {
                if (heldItem.method_31574(TODDItems.RAW_LEATHER)) {
                    if (!player.method_7337()) {
                        heldItem.method_7934(1);
                    }
                    world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)HAS_ITEM, (Comparable)Boolean.valueOf(true))).method_11657(ITEM_TYPE, (Comparable)((Object)ItemType.RAW_LEATHER)), 3);
                    world.method_8396(null, pos, class_3417.field_14574, class_3419.field_15245, 0.5f, 1.2f);
                    this.spawnPlacementParticles(world, pos);
                    return class_1269.field_5812;
                }
                if (heldItem.method_31574(TODDItems.TANNED_LEATHER)) {
                    if (!player.method_7337()) {
                        heldItem.method_7934(1);
                    }
                    world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)HAS_ITEM, (Comparable)Boolean.valueOf(true))).method_11657(ITEM_TYPE, (Comparable)((Object)ItemType.TANNED_LEATHER)), 3);
                    world.method_8396(null, pos, class_3417.field_14574, class_3419.field_15245, 0.5f, 1.2f);
                    this.spawnPlacementParticles(world, pos);
                    return class_1269.field_5812;
                }
            }
            if (((Boolean)state.method_11654((class_2769)HAS_ITEM)).booleanValue() && !TODDStoneBlocks.isProcessing(pos)) {
                if (state.method_11654(ITEM_TYPE) == ItemType.RAW_LEATHER && this.isHoldingSharpStick(player)) {
                    this.startLeatherProcessing(world, pos, player, ProcessType.SCRAPING_RAW_LEATHER);
                    return class_1269.field_5812;
                }
                if (state.method_11654(ITEM_TYPE) == ItemType.TANNED_LEATHER && this.isHoldingFlintKnife(player)) {
                    this.startLeatherProcessing(world, pos, player, ProcessType.PROCESSING_TANNED_LEATHER);
                    return class_1269.field_5812;
                }
            }
            if (((Boolean)state.method_11654((class_2769)HAS_ITEM)).booleanValue() && heldItem.method_7960() && !TODDStoneBlocks.isProcessing(pos)) {
                this.returnItemToPlayer(world, pos, state, player);
                world.method_8652(pos, this.method_9564(), 3);
                world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.5f, 1.0f);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }

        private boolean isHoldingSharpStick(class_1657 player) {
            class_1799 mainHand = player.method_6047();
            class_1799 offHand = player.method_6079();
            return mainHand.method_31574(TODDItems.SHARP_STICK) || mainHand.method_31574(TODDItems.SHORT_SHARP_STICK) || offHand.method_31574(TODDItems.SHARP_STICK) || offHand.method_31574(TODDItems.SHORT_SHARP_STICK);
        }

        private boolean isHoldingFlintKnife(class_1657 player) {
            class_1799 mainHand = player.method_6047();
            class_1799 offHand = player.method_6079();
            return mainHand.method_7909() instanceof FlintKnifeItem || offHand.method_7909() instanceof FlintKnifeItem;
        }

        private void startLeatherProcessing(class_1937 world, class_2338 pos, class_1657 player, ProcessType processType) {
            processingData.put(pos, new ProcessingData(world.method_8510(), player, processType));
            if (processType == ProcessType.SCRAPING_RAW_LEATHER) {
                world.method_8396(null, pos, class_3417.field_29541, class_3419.field_15245, 0.8f, 0.9f);
            } else {
                world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 0.8f, 1.0f);
            }
        }

        private void returnItemToPlayer(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
            if (!player.method_7337()) {
                class_1799 itemToReturn = switch (((ItemType)((Object)state.method_11654(ITEM_TYPE))).ordinal()) {
                    case 1 -> new class_1799((class_1935)TODDItems.RAW_LEATHER);
                    case 2 -> new class_1799((class_1935)TODDItems.TANNED_LEATHER);
                    default -> class_1799.field_8037;
                };
                if (!itemToReturn.method_7960()) {
                    player.method_7270(itemToReturn);
                }
            }
        }

        private void spawnPlacementParticles(class_1937 world, class_2338 pos) {
            if (world.field_9236) {
                for (int i = 0; i < 5; ++i) {
                    world.method_8406((class_2394)class_2398.field_11211, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, world.field_9229.method_43059() * 0.02, 0.1, world.field_9229.method_43059() * 0.02);
                }
            }
        }

        public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
            if (!state.method_27852(newState.method_26204()) && ((Boolean)state.method_11654((class_2769)HAS_ITEM)).booleanValue()) {
                class_1799 itemToDrop = switch (((ItemType)((Object)state.method_11654(ITEM_TYPE))).ordinal()) {
                    case 1 -> new class_1799((class_1935)TODDItems.RAW_LEATHER);
                    case 2 -> new class_1799((class_1935)TODDItems.TANNED_LEATHER);
                    default -> class_1799.field_8037;
                };
                if (!itemToDrop.method_7960()) {
                    class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.4, (double)pos.method_10260() + 0.5, itemToDrop);
                    world.method_8649((class_1297)itemEntity);
                }
            }
            processingData.remove(pos);
            super.method_9536(state, world, pos, newState, moved);
        }

        public boolean method_9542(class_2680 state) {
            return true;
        }

        public void randomTick(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
            if (TODDStoneBlocks.isProcessing(pos)) {
                this.processLeatherTick(world, pos, state);
            }
        }

        private void processLeatherTick(class_1937 world, class_2338 pos, class_2680 state) {
            ProcessingData data = processingData.get(pos);
            if (data == null || data.player == null) {
                this.resetProcessing(pos);
                return;
            }
            long currentTime = world.method_8510();
            long elapsedTicks = currentTime - data.startTime;
            if (elapsedTicks >= (switch (data.processType.ordinal()) {
                case 0 -> 1800L;
                case 1 -> 600L;
                default -> 600L;
            })) {
                this.completeLeatherProcessing(world, pos, data.player, data.processType);
            } else if (world.field_9236 && elapsedTicks % 40L == 0L) {
                this.spawnProcessingParticles(world, pos);
            }
        }

        private void completeLeatherProcessing(class_1937 world, class_2338 pos, class_1657 player, ProcessType processType) {
            class_1799 resultItem;
            switch (processType.ordinal()) {
                case 0: {
                    resultItem = new class_1799((class_1935)TODDItems.SCRAPED_LEATHER);
                    this.damageSharpSticks(player, world.field_9229);
                    break;
                }
                case 1: {
                    resultItem = new class_1799((class_1935)TODDItems.PROCESSED_LEATHER);
                    this.damagePlayerKnives(player, world.field_9229);
                    break;
                }
                default: {
                    resultItem = class_1799.field_8037;
                }
            }
            if (!resultItem.method_7960() && !player.method_7337()) {
                player.method_7270(resultItem);
            }
            world.method_8652(pos, this.method_9564(), 3);
            world.method_8396(null, pos, class_3417.field_14709, class_3419.field_15245, 0.8f, 1.2f);
            if (world.field_9236) {
                this.spawnCompletionParticles(world, pos);
            }
            processingData.remove(pos);
            TODDMod.LOGGER.info("Leather processing completed: " + String.valueOf((Object)processType) + " at " + String.valueOf(pos));
        }

        private void damageSharpSticks(class_1657 player, class_5819 random) {
            class_1799 offHand;
            int damageAmount = random.method_43048(6) + 1;
            class_1799 mainHand = player.method_6047();
            if ((mainHand.method_31574(TODDItems.SHARP_STICK) || mainHand.method_31574(TODDItems.SHORT_SHARP_STICK)) && mainHand.method_7963()) {
                for (int i = 0; i < damageAmount; ++i) {
                    mainHand.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
                }
            }
            if (((offHand = player.method_6079()).method_31574(TODDItems.SHARP_STICK) || offHand.method_31574(TODDItems.SHORT_SHARP_STICK)) && offHand.method_7963()) {
                for (int i = 0; i < damageAmount; ++i) {
                    offHand.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5810));
                }
            }
        }

        private void damagePlayerKnives(class_1657 player, class_5819 random) {
            class_1799 offHand;
            int damageAmount = random.method_43048(6) + 1;
            class_1799 mainHand = player.method_6047();
            if (mainHand.method_7909() instanceof FlintKnifeItem && mainHand.method_7963()) {
                for (int i = 0; i < damageAmount; ++i) {
                    mainHand.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
                }
            }
            if ((offHand = player.method_6079()).method_7909() instanceof FlintKnifeItem && offHand.method_7963()) {
                for (int i = 0; i < damageAmount; ++i) {
                    offHand.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5810));
                }
            }
        }

        private void spawnProcessingParticles(class_1937 world, class_2338 pos) {
            for (int i = 0; i < 3; ++i) {
                world.method_8406((class_2394)class_2398.field_11205, (double)pos.method_10263() + 0.3 + world.field_9229.method_43058() * 0.4, (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.3 + world.field_9229.method_43058() * 0.4, world.field_9229.method_43059() * 0.02, 0.1, world.field_9229.method_43059() * 0.02);
            }
        }

        private void spawnCompletionParticles(class_1937 world, class_2338 pos) {
            for (int i = 0; i < 10; ++i) {
                world.method_8406((class_2394)class_2398.field_11211, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, world.field_9229.method_43059() * 0.1, 0.2, world.field_9229.method_43059() * 0.1);
            }
        }

        private void resetProcessing(class_2338 pos) {
            processingData.remove(pos);
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            class_2338 blockPos = pos.method_10074();
            return FlatStoneBlock.method_16361((class_1922)world, (class_2338)blockPos) || FlatStoneBlock.method_20044((class_4538)world, (class_2338)blockPos, (class_2350)class_2350.field_11036);
        }
    }
}

