/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.hunger;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class FoodBalanceManager {
    private static final Map<UUID, FoodBalanceData> playerFoodData = new HashMap<UUID, FoodBalanceData>();

    public static void updateFoodBalance(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        UUID playerId = player.method_5667();
        FoodBalanceData data = playerFoodData.computeIfAbsent(playerId, k -> new FoodBalanceData());
        if (data.hungerCooldown > 0) {
            --data.hungerCooldown;
        }
        if (player.method_37908().method_8510() % 600L == 0L) {
            data.decay();
        }
        FoodBalanceManager.checkFoodImbalance(player, data);
    }

    public static void addFoodPoints(class_1657 player, FoodType foodType, int points) {
        if (!(player instanceof class_3222)) {
            return;
        }
        UUID playerId = player.method_5667();
        FoodBalanceData data = playerFoodData.computeIfAbsent(playerId, k -> new FoodBalanceData());
        data.add(foodType, points);
        if (data.get(foodType) > 50) {
            data.set(foodType, 50);
        }
    }

    private static void checkFoodImbalance(class_1657 player, FoodBalanceData data) {
        int[] values = new int[]{data.meat, data.vegetable, data.fruit, data.herbal, data.flour};
        int maxValue = 0;
        int secondMaxValue = 0;
        for (int value : values) {
            if (value > maxValue) {
                secondMaxValue = maxValue;
                maxValue = value;
                continue;
            }
            if (value <= secondMaxValue) continue;
            secondMaxValue = value;
        }
        if (maxValue - secondMaxValue >= 16 && data.hungerCooldown == 0) {
            player.method_6092(new class_1293(class_1294.field_5903, 1200, 0, false, true));
            data.hungerCooldown = 2400;
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76Nutrition imbalance! Too much of one type of food."), true);
        }
    }

    public static FoodBalanceData getFoodData(class_1657 player) {
        return playerFoodData.get(player.method_5667());
    }

    public static int getFoodValue(class_1657 player, FoodType type) {
        FoodBalanceData data = playerFoodData.get(player.method_5667());
        return data != null ? data.get(type) : 0;
    }

    public static class FoodBalanceData {
        public int meat = 0;
        public int vegetable = 0;
        public int fruit = 0;
        public int herbal = 0;
        public int flour = 0;
        public int hungerCooldown = 0;

        public void fromNbt(class_2487 nbt) {
            this.meat = nbt.method_10550("Meat");
            this.vegetable = nbt.method_10550("Vegetable");
            this.fruit = nbt.method_10550("Fruit");
            this.herbal = nbt.method_10550("Herbal");
            this.flour = nbt.method_10550("Flour");
            this.hungerCooldown = nbt.method_10550("HungerCooldown");
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("Meat", this.meat);
            nbt.method_10569("Vegetable", this.vegetable);
            nbt.method_10569("Fruit", this.fruit);
            nbt.method_10569("Herbal", this.herbal);
            nbt.method_10569("Flour", this.flour);
            nbt.method_10569("HungerCooldown", this.hungerCooldown);
            return nbt;
        }

        public void decay() {
            if (this.meat > 0) {
                this.meat = Math.max(0, this.meat - 1);
            }
            if (this.vegetable > 0) {
                this.vegetable = Math.max(0, this.vegetable - 1);
            }
            if (this.fruit > 0) {
                this.fruit = Math.max(0, this.fruit - 1);
            }
            if (this.herbal > 0) {
                this.herbal = Math.max(0, this.herbal - 1);
            }
            if (this.flour > 0) {
                this.flour = Math.max(0, this.flour - 1);
            }
        }

        public int get(FoodType type) {
            switch (type.ordinal()) {
                case 0: {
                    return this.meat;
                }
                case 1: {
                    return this.vegetable;
                }
                case 2: {
                    return this.fruit;
                }
                case 3: {
                    return this.herbal;
                }
                case 4: {
                    return this.flour;
                }
            }
            return 0;
        }

        public void set(FoodType type, int value) {
            switch (type.ordinal()) {
                case 0: {
                    this.meat = Math.max(0, value);
                    break;
                }
                case 1: {
                    this.vegetable = Math.max(0, value);
                    break;
                }
                case 2: {
                    this.fruit = Math.max(0, value);
                    break;
                }
                case 3: {
                    this.herbal = Math.max(0, value);
                    break;
                }
                case 4: {
                    this.flour = Math.max(0, value);
                }
            }
        }

        public void add(FoodType type, int amount) {
            this.set(type, this.get(type) + amount);
        }
    }

    public static enum FoodType {
        MEAT("meat", 0xFF6B6B),
        VEGETABLE("vegetable", 8311585),
        FRUIT("fruit", 16765286),
        HERBAL("herbal", 448160),
        FLOUR("flour", 0xFFFCF9);

        public final String name;
        public final int color;

        private FoodType(String name, int color) {
            this.name = name;
            this.color = color;
        }
    }
}

