/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.item;

import com.ferrum.todd.item.TODDItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class FlintKnifeItem
extends class_1829 {
    private static final Map<UUID, Long> holdStartTimes = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> holdDurations = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> cooldownEndTimes = new HashMap<UUID, Long>();
    private static final Map<UUID, class_2680> targetBlocks = new HashMap<UUID, class_2680>();
    private static final Map<UUID, Integer> requiredTimes = new HashMap<UUID, Integer>();
    private static final Random random = new Random();
    private static final Map<String, Long> sharpnessTimers = new HashMap<String, Long>();
    private static final long SHARPNESS_TIMER_DURATION = 100L;
    private static final int LEAVES_TIME = 15;
    private static final int LOGS_TIME = 30;
    private static final class_2680[] EFFECTIVE_BLOCKS = new class_2680[]{class_2246.field_10255.method_9564(), class_2246.field_10102.method_9564(), class_2246.field_10534.method_9564(), class_2246.field_10503.method_9564(), class_2246.field_9988.method_9564(), class_2246.field_10539.method_9564(), class_2246.field_10335.method_9564(), class_2246.field_10098.method_9564(), class_2246.field_10035.method_9564(), class_2246.field_37551.method_9564(), class_2246.field_28673.method_9564(), class_2246.field_28674.method_9564(), class_2246.field_10479.method_9564(), class_2246.field_10214.method_9564(), class_2246.field_10112.method_9564(), class_2246.field_10313.method_9564(), class_2246.field_10343.method_9564(), class_2246.field_10251.method_9564(), class_2246.field_10559.method_9564(), class_2246.field_10580.method_9564(), class_2246.field_10240.method_9564(), class_2246.field_10556.method_9564()};
    private final int maxSharpness;

    public FlintKnifeItem(class_1832 toolMaterial, float attackDamage, float attackSpeed, int maxDurability, int maxSharpness, class_1792.class_1793 settings) {
        super(toolMaterial, (int)attackDamage, attackSpeed, settings);
        this.maxSharpness = maxSharpness;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        this.updateSharpnessTimer(stack, world);
        if (!stack.method_7985() || !stack.method_7969().method_10545("Sharpness")) {
            this.initializeSharpness(stack, 0);
        }
    }

    private void updateSharpnessTimer(class_1799 stack, class_1937 world) {
        if (world.field_9236) {
            return;
        }
        String itemId = this.getItemStackId(stack);
        if (this.hasSharpnessTag(stack)) {
            sharpnessTimers.remove(itemId);
            return;
        }
        if (sharpnessTimers.containsKey(itemId)) {
            long startTime = sharpnessTimers.get(itemId);
            long currentTime = world.method_8510();
            long elapsedTicks = currentTime - startTime;
            if (elapsedTicks >= 100L) {
                this.setMaxSharpness(stack);
                this.addSharpnessTag(stack);
                sharpnessTimers.remove(itemId);
            }
        } else {
            sharpnessTimers.put(itemId, world.method_8510());
        }
    }

    private String getItemStackId(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10545("ItemUUID")) {
            return nbt.method_10558("ItemUUID");
        }
        String newUuid = UUID.randomUUID().toString();
        class_2487 newNbt = stack.method_7948();
        newNbt.method_10582("ItemUUID", newUuid);
        return newUuid;
    }

    private boolean hasSharpnessTag(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10577("withsharpness");
    }

    private void addSharpnessTag(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10556("withsharpness", true);
    }

    private void setMaxSharpness(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("Sharpness", this.maxSharpness);
        nbt.method_10569("MaxSharpness", this.maxSharpness);
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        this.initializeSharpness(stack, 0);
        return stack;
    }

    private void initializeSharpness(class_1799 stack, int sharpness) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("Sharpness", sharpness);
        nbt.method_10569("MaxSharpness", this.maxSharpness);
    }

    public int getSharpness(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null ? nbt.method_10550("Sharpness") : 0;
    }

    public int getMaxSharpness(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null ? nbt.method_10550("MaxSharpness") : this.maxSharpness;
    }

    public void decreaseSharpness(class_1799 stack, int amount) {
        int currentSharpness = this.getSharpness(stack);
        int newSharpness = Math.max(0, currentSharpness - amount);
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("Sharpness", newSharpness);
    }

    private float getSharpnessMultiplier(class_1799 stack) {
        int sharpness = this.getSharpness(stack);
        int maxSharpness = this.getMaxSharpness(stack);
        if (sharpness == 0) {
            return 0.0f;
        }
        float progress = (float)sharpness / (float)maxSharpness;
        if (sharpness == 1) {
            return 0.3f;
        }
        return 0.3f + 0.7f * ((float)(sharpness - 1) / (float)(maxSharpness - 1));
    }

    private void applyDamage(class_1799 stack, class_1657 player, int damage) {
        stack.method_7956(damage, (class_1309)player, p -> p.method_20236(player.method_6058()));
        this.decreaseSharpness(stack, damage);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        int sharpness = this.getSharpness(stack);
        int maxSharpness = this.getMaxSharpness(stack);
        String itemId = this.getItemStackId(stack);
        if (sharpnessTimers.containsKey(itemId) && !this.hasSharpnessTag(stack)) {
            long startTime = sharpnessTimers.get(itemId);
            long currentTime = world != null ? world.method_8510() : 0L;
            long elapsedTicks = currentTime - startTime;
            long remainingSeconds = Math.max(0L, (100L - elapsedTicks) / 20L);
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.todd.sharpening_in", (Object[])new Object[]{remainingSeconds + 1L}).method_27692(class_124.field_1054));
        }
        if (context.method_8035()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.todd.sharpness", (Object[])new Object[]{sharpness, maxSharpness}).method_27692(class_124.field_1080));
            if (this.hasSharpnessTag(stack)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.todd.sharpened").method_27692(class_124.field_1060));
            }
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_2680 targetedBlock;
        class_1799 itemStack = user.method_5998(hand);
        if (this.getSharpness(itemStack) == 0) {
            user.method_7353((class_2561)class_2561.method_43471((String)"message.todd.knife_too_dull"), true);
            return class_1271.method_22431((Object)itemStack);
        }
        if (this.isOnCooldown(user)) {
            return class_1271.method_22431((Object)itemStack);
        }
        class_3965 hitResult = (class_3965)user.method_5745(5.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && (targetedBlock = world.method_8320(hitResult.method_17777())).method_26164(class_3481.field_15475)) {
            user.method_6019(hand);
            holdStartTimes.put(user.method_5667(), world.method_8510());
            targetBlocks.put(user.method_5667(), targetedBlock);
            requiredTimes.put(user.method_5667(), 30);
            return class_1271.method_22428((Object)itemStack);
        }
        user.method_7353((class_2561)class_2561.method_43471((String)"message.todd.knife_need_log"), true);
        return class_1271.method_22430((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1657 player;
        UUID playerId;
        if (user instanceof class_1657 && holdStartTimes.containsKey(playerId = (player = (class_1657)user).method_5667())) {
            long currentTime = world.method_8510();
            long holdDuration = currentTime - holdStartTimes.get(playerId);
            int holdSeconds = (int)(holdDuration / 20L);
            int requiredTime = requiredTimes.getOrDefault(playerId, 30);
            class_2680 targetBlock = targetBlocks.get(playerId);
            if (holdSeconds >= requiredTime) {
                this.processLogScraping(player, stack, holdSeconds, targetBlock);
            } else {
                if (!player.method_7337()) {
                    this.applyDamage(stack, player, 1);
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"message.todd.knife_interrupted"), true);
            }
            this.cleanupPlayerData(playerId);
        }
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        class_1657 player;
        UUID playerId;
        if (user instanceof class_1657 && holdStartTimes.containsKey(playerId = (player = (class_1657)user).method_5667())) {
            class_2680 currentTargetBlock;
            class_2680 originalTargetBlock = targetBlocks.get(playerId);
            class_3965 hitResult = (class_3965)player.method_5745(5.0, 0.0f, false);
            boolean isLookingAtTarget = false;
            if (hitResult.method_17783() == class_239.class_240.field_1332 && (currentTargetBlock = world.method_8320(hitResult.method_17777())).method_26164(class_3481.field_15475)) {
                isLookingAtTarget = true;
            }
            if (!isLookingAtTarget) {
                player.method_6021();
                if (!player.method_7337()) {
                    this.applyDamage(stack, player, 1);
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"message.todd.knife_stopped_looking"), true);
                this.cleanupPlayerData(playerId);
                return;
            }
            long currentTime = world.method_8510();
            long holdDuration = currentTime - holdStartTimes.get(playerId);
            int holdSeconds = (int)(holdDuration / 20L);
            int requiredTime = requiredTimes.getOrDefault(playerId, 30);
            if (holdSeconds != holdDurations.getOrDefault(playerId, -1)) {
                holdDurations.put(playerId, holdSeconds);
            }
            if (holdSeconds >= requiredTime) {
                class_2680 targetBlock = targetBlocks.get(playerId);
                this.processLogScraping(player, stack, holdSeconds, targetBlock);
                this.cleanupPlayerData(playerId);
                player.method_6021();
            }
        }
    }

    private void processLogScraping(class_1657 player, class_1799 stack, int holdSeconds, class_2680 targetBlock) {
        if (targetBlock == null) {
            return;
        }
        class_1799 drop = class_1799.field_8037;
        int chance = random.nextInt(4);
        switch (chance) {
            case 0: {
                drop = new class_1799((class_1935)TODDItems.SHORT_STICK);
                break;
            }
            case 1: {
                drop = new class_1799((class_1935)TODDItems.SMALL_STICK);
                break;
            }
            case 2: {
                drop = new class_1799((class_1935)TODDItems.STICK);
                break;
            }
            case 3: {
                drop = new class_1799((class_1935)TODDItems.WOOD_CHIPS);
            }
        }
        if (!drop.method_7960()) {
            player.method_7270(drop);
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"message.todd.knife_logs_success"), true);
        if (!player.method_7337()) {
            this.applyDamage(stack, player, 2);
        }
        player.method_7322(3.0f);
        this.setCooldown(player, 2);
    }

    private void cleanupPlayerData(UUID playerId) {
        holdStartTimes.remove(playerId);
        holdDurations.remove(playerId);
        targetBlocks.remove(playerId);
        requiredTimes.remove(playerId);
    }

    private void setCooldown(class_1657 player, int seconds) {
        cooldownEndTimes.put(player.method_5667(), player.method_37908().method_8510() + (long)(seconds * 20));
    }

    private boolean isOnCooldown(class_1657 player) {
        long endTime;
        UUID playerId = player.method_5667();
        if (!cooldownEndTimes.containsKey(playerId)) {
            return false;
        }
        long currentTime = player.method_37908().method_8510();
        if (currentTime >= (endTime = cooldownEndTimes.get(playerId).longValue())) {
            cooldownEndTimes.remove(playerId);
            return false;
        }
        return true;
    }

    public static int getHoldDuration(UUID playerId) {
        return holdDurations.getOrDefault(playerId, 0);
    }

    public static int getRequiredTime(UUID playerId) {
        return requiredTimes.getOrDefault(playerId, 30);
    }

    public static float getProgress(UUID playerId) {
        int holdDuration = FlintKnifeItem.getHoldDuration(playerId);
        int requiredTime = FlintKnifeItem.getRequiredTime(playerId);
        if (requiredTime > 0) {
            return Math.min(1.0f, (float)holdDuration / (float)requiredTime);
        }
        return 0.0f;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return this.isEffectiveAgainst(state);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (!this.isEffectiveAgainst(state)) {
            return 1.0f;
        }
        int sharpness = this.getSharpness(stack);
        if (sharpness == 0) {
            return 0.5f;
        }
        float baseSpeed = 8.0f;
        return baseSpeed * this.getSharpnessMultiplier(stack);
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!this.isEffectiveAgainst(state)) {
            return false;
        }
        int sharpness = this.getSharpness(stack);
        if (state.method_27852(class_2246.field_10479) || state.method_27852(class_2246.field_10214) || state.method_27852(class_2246.field_10112) || state.method_27852(class_2246.field_10313)) {
            if (!world.field_9236 && miner instanceof class_1657) {
                class_1657 player = (class_1657)miner;
                world.method_8651(pos, false, (class_1297)player);
                if (state.method_27852(class_2246.field_10479)) {
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10479));
                } else if (state.method_27852(class_2246.field_10214)) {
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10214));
                } else if (state.method_27852(class_2246.field_10112)) {
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10112));
                } else if (state.method_27852(class_2246.field_10313)) {
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10313));
                }
                world.method_8444(null, 2001, pos, class_2248.method_9507((class_2680)state));
            }
            if (sharpness > 0) {
                int sharpnessLoss = world.field_9229.method_43048(2) + 1;
                this.decreaseSharpness(stack, sharpnessLoss);
            }
            if (!world.field_9236 && stack.method_7963()) {
                stack.method_7956(1, miner, entity -> entity.method_20236(miner.method_6058()));
            }
            return true;
        }
        if (state.method_27852(class_2246.field_10251) || state.method_27852(class_2246.field_10559)) {
            if (!world.field_9236 && miner instanceof class_1657) {
                class_1657 player = (class_1657)miner;
                world.method_8651(pos, false, (class_1297)player);
                if (state.method_27852(class_2246.field_10251)) {
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10251));
                } else if (state.method_27852(class_2246.field_10559)) {
                    class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10559));
                }
                world.method_8444(null, 2001, pos, class_2248.method_9507((class_2680)state));
            }
            if (sharpness > 0) {
                int sharpnessLoss = world.field_9229.method_43048(2) + 1;
                this.decreaseSharpness(stack, sharpnessLoss);
            }
            if (!world.field_9236 && stack.method_7963()) {
                stack.method_7956(1, miner, entity -> entity.method_20236(miner.method_6058()));
            }
            return true;
        }
        if (!world.field_9236 && miner instanceof class_1657) {
            class_1657 player = (class_1657)miner;
            world.method_8651(pos, true, (class_1297)player);
        }
        if (sharpness > 0) {
            int sharpnessLoss = world.field_9229.method_43048(4) + 1;
            this.decreaseSharpness(stack, sharpnessLoss);
        }
        if (!world.field_9236 && stack.method_7963()) {
            stack.method_7956(1, miner, entity -> entity.method_20236(miner.method_6058()));
        }
        return true;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (this.getSharpness(stack) == 0) {
            return false;
        }
        int sharpnessLoss = attacker.method_37908().field_9229.method_43048(3) + 1;
        this.decreaseSharpness(stack, sharpnessLoss);
        if (!attacker.method_37908().field_9236 && stack.method_7963()) {
            stack.method_7956(1, attacker, entity -> entity.method_20236(attacker.method_6058()));
        }
        return true;
    }

    public boolean method_7856(class_2680 state) {
        return this.isEffectiveAgainst(state);
    }

    private boolean isEffectiveAgainst(class_2680 state) {
        for (class_2680 effectiveBlock : EFFECTIVE_BLOCKS) {
            if (!state.method_27852(effectiveBlock.method_26204())) continue;
            return true;
        }
        return false;
    }

    public class_1269 method_7884(class_1838 context) {
        return class_1269.field_5811;
    }

    public boolean canUseInCrafting(class_1799 stack) {
        return this.getSharpness(stack) > 0;
    }

    public boolean method_7857() {
        return true;
    }

    public class_1799 getRecipeRemainder(class_1799 stack) {
        if (!this.canUseInCrafting(stack)) {
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_7972();
        int sharpnessLoss = 1 + (int)(Math.random() * 4.0);
        this.decreaseSharpness(remainder, sharpnessLoss);
        if (remainder.method_7963()) {
            remainder.method_7974(remainder.method_7919() + 1);
        }
        if (this.getSharpness(remainder) == 0 || remainder.method_7919() >= remainder.method_7936()) {
            return class_1799.field_8037;
        }
        return remainder;
    }
}

