/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.item;

import com.ferrum.todd.item.TODDItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5272;

public class SharpStickItem
extends class_1829 {
    private static final Map<UUID, Long> holdStartTimes = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> holdDurations = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> cooldownEndTimes = new HashMap<UUID, Long>();
    private static final Map<UUID, class_2680> targetBlocks = new HashMap<UUID, class_2680>();
    private static final Map<UUID, Integer> requiredTimes = new HashMap<UUID, Integer>();
    private static final Random random = new Random();
    private static final int MIN_HOLD_TIME = 30;
    private static final int MAX_HOLD_TIME = 45;
    private static final int MIN_COBWEB_TIME = 30;
    private static final int MAX_COBWEB_TIME = 120;

    public SharpStickItem(float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super((class_1832)class_1834.field_8922, (int)attackDamage, attackSpeed, settings);
    }

    public static void registerModelPredicate() {
        class_5272.method_27881((class_2960)new class_2960("aiming_at_wood"), (stack, world, entity, seed) -> {
            class_2680 targetedBlock;
            class_3965 hitResult;
            class_1657 player;
            if (entity == null || world == null) {
                return 0.0f;
            }
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_6047() == stack && (hitResult = (class_3965)player.method_5745(5.0, 0.0f, false)).method_17783() == class_239.class_240.field_1332 && ((targetedBlock = world.method_8320(hitResult.method_17777())).method_26164(class_3481.field_15475) || targetedBlock.method_27852(class_2246.field_10343))) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    public boolean method_7856(class_2680 state) {
        return state.method_27852(class_2246.field_10343) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10102);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (state.method_27852(class_2246.field_10343)) {
            return 15.0f;
        }
        if (state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10102)) {
            return 0.5f;
        }
        return 0.5f;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10102);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_2680 targetedBlock;
        class_1799 itemStack = user.method_5998(hand);
        if (this.isOnCooldown(user)) {
            return class_1271.method_22431((Object)itemStack);
        }
        class_3965 hitResult = (class_3965)user.method_5745(5.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && ((targetedBlock = world.method_8320(hitResult.method_17777())).method_26164(class_3481.field_15475) || targetedBlock.method_27852(class_2246.field_10343))) {
            user.method_6019(hand);
            holdStartTimes.put(user.method_5667(), world.method_8510());
            targetBlocks.put(user.method_5667(), targetedBlock);
            int requiredTime = targetedBlock.method_27852(class_2246.field_10343) ? 30 + random.nextInt(91) : 30 + random.nextInt(16);
            requiredTimes.put(user.method_5667(), requiredTime);
            return class_1271.method_22428((Object)itemStack);
        }
        user.method_7353((class_2561)class_2561.method_43471((String)"message.todd.need_wood_or_cobweb"), true);
        return class_1271.method_22430((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1657 player;
        UUID playerId;
        if (user instanceof class_1657 && holdStartTimes.containsKey(playerId = (player = (class_1657)user).method_5667())) {
            long currentTime = world.method_8510();
            long holdDuration = currentTime - holdStartTimes.get(playerId);
            int holdSeconds = (int)(holdDuration / 20L);
            int requiredTime = requiredTimes.getOrDefault(playerId, 45);
            class_2680 targetBlock = targetBlocks.get(playerId);
            if (holdSeconds >= requiredTime) {
                if (targetBlock != null && targetBlock.method_27852(class_2246.field_10343)) {
                    this.processCobwebBreaking(player, stack, holdSeconds);
                } else {
                    this.processWoodScraping(player, stack, holdSeconds, false);
                }
            } else if (targetBlock != null && targetBlock.method_27852(class_2246.field_10343)) {
                if (!player.method_7337()) {
                    stack.method_7956(3, (class_1309)player, p -> p.method_20236(player.method_6058()));
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"message.todd.failed_cobweb_tool_damaged"), true);
            }
            holdStartTimes.remove(playerId);
            holdDurations.remove(playerId);
            targetBlocks.remove(playerId);
            requiredTimes.remove(playerId);
        }
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        class_1657 player;
        UUID playerId;
        if (user instanceof class_1657 && holdStartTimes.containsKey(playerId = (player = (class_1657)user).method_5667())) {
            class_2680 targetBlock;
            class_2680 originalTargetBlock = targetBlocks.get(playerId);
            class_3965 hitResult = (class_3965)player.method_5745(5.0, 0.0f, false);
            boolean isLookingAtTarget = false;
            class_2680 currentTargetBlock = null;
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                currentTargetBlock = world.method_8320(hitResult.method_17777());
                if (originalTargetBlock.method_26164(class_3481.field_15475) && currentTargetBlock.method_26164(class_3481.field_15475) || originalTargetBlock.method_27852(class_2246.field_10343) && currentTargetBlock.method_27852(class_2246.field_10343)) {
                    isLookingAtTarget = true;
                    targetBlocks.put(playerId, currentTargetBlock);
                }
            }
            if (!isLookingAtTarget) {
                player.method_6021();
                if (originalTargetBlock != null && originalTargetBlock.method_27852(class_2246.field_10343)) {
                    if (!player.method_7337()) {
                        stack.method_7956(3, (class_1309)player, p -> p.method_20236(player.method_6058()));
                    }
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.todd.stopped_looking_cobweb"), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.todd.stopped_looking_target"), true);
                }
                holdStartTimes.remove(playerId);
                holdDurations.remove(playerId);
                targetBlocks.remove(playerId);
                requiredTimes.remove(playerId);
                return;
            }
            long currentTime = world.method_8510();
            long holdDuration = currentTime - holdStartTimes.get(playerId);
            int holdSeconds = (int)(holdDuration / 20L);
            int requiredTime = requiredTimes.getOrDefault(playerId, 45);
            if (holdSeconds != holdDurations.getOrDefault(playerId, -1)) {
                holdDurations.put(playerId, holdSeconds);
            }
            if (world.field_9236 && holdSeconds > 0 && holdSeconds < requiredTime && (targetBlock = targetBlocks.get(playerId)) != null) {
                if (targetBlock.method_27852(class_2246.field_10343)) {
                    this.spawnCobwebParticles(world, player);
                } else {
                    this.spawnWoodParticles(world, player, targetBlock);
                }
            }
            if (holdSeconds >= requiredTime) {
                targetBlock = targetBlocks.get(playerId);
                if (targetBlock != null && targetBlock.method_27852(class_2246.field_10343)) {
                    this.processCobwebBreaking(player, stack, holdSeconds);
                } else {
                    this.processWoodScraping(player, stack, holdSeconds, false);
                }
                holdStartTimes.remove(playerId);
                holdDurations.remove(playerId);
                targetBlocks.remove(playerId);
                requiredTimes.remove(playerId);
                player.method_6021();
            }
        }
    }

    private void spawnCobwebParticles(class_1937 world, class_1657 player) {
        for (int i = 0; i < 5; ++i) {
            double x = player.method_23317() + (random.nextDouble() - 0.5) * 2.0;
            double y = player.method_23318() + random.nextDouble() * 2.0;
            double z = player.method_23321() + (random.nextDouble() - 0.5) * 2.0;
            world.method_8406((class_2394)class_2398.field_23956, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    private void processCobwebBreaking(class_1657 player, class_1799 stack, int holdSeconds) {
        class_2680 targetedBlock;
        double chance = random.nextDouble() * 100.0;
        class_1799 drop = class_1799.field_8037;
        class_5250 message = class_2561.method_43471((String)"message.todd.failed_gather_threads");
        if (chance < 50.0) {
            count = 1 + random.nextInt(3);
            drop = new class_1799((class_1935)TODDItems.SHORT_THREAD, count);
            message = class_2561.method_43469((String)"message.todd.received_short_thread", (Object[])new Object[]{count});
        } else if (chance < 80.0) {
            count = 1 + random.nextInt(2);
            drop = new class_1799((class_1935)TODDItems.SMALL_THREAD, count);
            message = class_2561.method_43469((String)"message.todd.received_small_thread", (Object[])new Object[]{count});
        }
        if (!drop.method_7960()) {
            player.method_7270(drop);
            player.method_7353((class_2561)message, true);
        } else {
            player.method_7353((class_2561)message, true);
        }
        if (!player.method_7337()) {
            stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
        }
        player.method_7322(5.0f);
        class_3965 hitResult = (class_3965)player.method_5745(5.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332 && (targetedBlock = player.method_37908().method_8320(hitResult.method_17777())).method_27852(class_2246.field_10343)) {
            player.method_37908().method_22352(hitResult.method_17777(), false);
        }
        if (player.method_37908().method_8608()) {
            this.spawnCobwebParticles(player.method_37908(), player);
        }
        this.setCooldown(player, 3);
    }

    public int getMaxUseTime(class_1799 stack, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            UUID playerId = player.method_5667();
            int requiredTime = requiredTimes.getOrDefault(playerId, 45);
            return requiredTime * 20;
        }
        return 900;
    }

    public int getRemainingUseTime(class_1799 stack, class_1309 user) {
        class_1657 player;
        UUID playerId;
        if (user instanceof class_1657 && holdStartTimes.containsKey(playerId = (player = (class_1657)user).method_5667())) {
            long currentTime = user.method_37908().method_8510();
            long holdDuration = currentTime - holdStartTimes.get(playerId);
            int holdTicks = (int)holdDuration;
            int maxUseTime = this.getMaxUseTime(stack, user);
            return Math.max(0, maxUseTime - holdTicks);
        }
        return 0;
    }

    private void spawnWoodParticles(class_1937 world, class_1657 player, class_2680 woodBlock) {
        for (int i = 0; i < 3; ++i) {
            double x = player.method_23317() + (random.nextDouble() - 0.5) * 1.5;
            double y = player.method_23318() + random.nextDouble() * 1.5;
            double z = player.method_23321() + (random.nextDouble() - 0.5) * 1.5;
            world.method_8406((class_2394)new class_2388(class_2398.field_11217, woodBlock), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, entity -> entity.method_20236(attacker.method_6058()));
        return true;
    }

    private void processWoodScraping(class_1657 player, class_1799 stack, int holdSeconds, boolean isShort) {
        double chance = random.nextDouble() * 100.0;
        class_1799 drop = class_1799.field_8037;
        class_5250 message = class_2561.method_43471((String)"message.todd.failed_scrape");
        if (chance < 10.0) {
            drop = new class_1799((class_1935)TODDItems.STICK);
            message = class_2561.method_43471((String)"message.todd.received_stick");
        } else if (chance < 30.0) {
            drop = new class_1799((class_1935)TODDItems.SHORT_STICK);
            message = class_2561.method_43471((String)"message.todd.received_short_stick");
        } else if (chance < 45.0) {
            drop = new class_1799((class_1935)TODDItems.SMALL_STICK);
            message = class_2561.method_43471((String)"message.todd.received_small_stick");
        } else if (chance < 70.0) {
            drop = new class_1799((class_1935)TODDItems.WOOD_CHIPS);
            message = class_2561.method_43471((String)"message.todd.received_wood_chips");
        }
        if (!drop.method_7960()) {
            class_2680 woodBlock;
            player.method_7270(drop);
            player.method_7353((class_2561)message, true);
            if (!player.method_7337()) {
                stack.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            }
            if (player.method_37908().method_8608() && (woodBlock = targetBlocks.get(player.method_5667())) != null) {
                this.spawnWoodParticles(player.method_37908(), player, woodBlock);
            }
            this.setCooldown(player, 5);
        } else {
            player.method_7353((class_2561)message, true);
        }
    }

    private void setCooldown(class_1657 player, int seconds) {
        cooldownEndTimes.put(player.method_5667(), player.method_37908().method_8510() + (long)(seconds * 20));
    }

    private boolean isOnCooldown(class_1657 player) {
        long endTime;
        UUID playerId = player.method_5667();
        if (!cooldownEndTimes.containsKey(playerId)) {
            return false;
        }
        long currentTime = player.method_37908().method_8510();
        if (currentTime >= (endTime = cooldownEndTimes.get(playerId).longValue())) {
            cooldownEndTimes.remove(playerId);
            return false;
        }
        return true;
    }

    public static int getHoldDuration(UUID playerId) {
        return holdDurations.getOrDefault(playerId, 0);
    }

    public static int getRequiredTime(UUID playerId) {
        return requiredTimes.getOrDefault(playerId, 45);
    }

    public static int getMinHoldTime() {
        return 30;
    }

    public static int getMaxHoldTime() {
        return 45;
    }

    public static float getProgress(UUID playerId) {
        int holdDuration = SharpStickItem.getHoldDuration(playerId);
        int requiredTime = SharpStickItem.getRequiredTime(playerId);
        if (requiredTime > 0) {
            return Math.min(1.0f, (float)holdDuration / (float)requiredTime);
        }
        return 0.0f;
    }

    public static boolean isOnCooldown(UUID playerId) {
        return false;
    }

    public static long getRemainingCooldown(UUID playerId) {
        return 0L;
    }
}

