/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.item;

import com.ferrum.todd.item.TODDItems;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class SmolderingEmberItem
extends class_1792 {
    public SmolderingEmberItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2487 nbt = stack.method_7948();
            if (!nbt.method_10545("CreationTime")) {
                nbt.method_10544("CreationTime", world.method_8510());
                return;
            }
            long creationTime = nbt.method_10537("CreationTime");
            long currentTime = world.method_8510();
            long timeInInventory = (currentTime - creationTime) / 20L;
            if (timeInInventory >= 10L) {
                player.method_31548().method_5441(slot);
                world.method_8396(null, entity.method_24515(), class_3417.field_15102, entity.method_5634(), 0.5f, 1.0f);
            }
        }
    }

    public static void checkForFireCreation(class_1542 itemEntity) {
        class_1937 world = itemEntity.method_37908();
        class_1799 stack = itemEntity.method_6983();
        if (stack.method_7909() != TODDItems.SMOLDERING_EMBER || world.method_8608()) {
            return;
        }
        if (!SmolderingEmberItem.canCreateFire(world, itemEntity.method_24515())) {
            return;
        }
        class_238 searchBox = new class_238(itemEntity.method_24515()).method_1014(1.0);
        int driedGrassCount = 0;
        int woodChipsCount = 0;
        for (class_1542 nearbyEntity : world.method_8390(class_1542.class, searchBox, e -> true)) {
            class_1799 nearbyStack = nearbyEntity.method_6983();
            if (nearbyStack.method_7909() == TODDItems.DRIED_GRASS) {
                driedGrassCount += nearbyStack.method_7947();
                continue;
            }
            if (nearbyStack.method_7909() != TODDItems.WOOD_CHIPS) continue;
            woodChipsCount += nearbyStack.method_7947();
        }
        if (driedGrassCount >= 5 && woodChipsCount >= 8) {
            world.method_8501(itemEntity.method_24515(), class_2246.field_10036.method_9564());
            SmolderingEmberItem.removeRequiredItems(world, searchBox, 5, 8);
            itemEntity.method_31472();
            world.method_8396(null, itemEntity.method_24515(), class_3417.field_15145, itemEntity.method_5634(), 1.0f, 1.0f);
        }
    }

    private static boolean canCreateFire(class_1937 world, class_2338 pos) {
        if (world.method_8419() && world.method_8311(pos)) {
            return false;
        }
        if (world.method_8546()) {
            return false;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_6880 biome = serverWorld.method_23753(pos);
            if (biome.method_40220(class_6908.field_41753) || biome.method_40220(class_6908.field_37389) || biome.method_40220(class_6908.field_41756)) {
                return false;
            }
            if (((class_1959)biome.comp_349()).method_8712() < 0.15f) {
                return false;
            }
        }
        return true;
    }

    private static void removeRequiredItems(class_1937 world, class_238 area, int driedGrassNeeded, int woodChipsNeeded) {
        int grassRemoved = 0;
        int chipsRemoved = 0;
        for (class_1542 entity : world.method_8390(class_1542.class, area, e -> true)) {
            int toRemove;
            class_1799 stack = entity.method_6983();
            if (grassRemoved < driedGrassNeeded && stack.method_7909() == TODDItems.DRIED_GRASS) {
                toRemove = Math.min(stack.method_7947(), driedGrassNeeded - grassRemoved);
                stack.method_7934(toRemove);
                grassRemoved += toRemove;
                if (stack.method_7960()) {
                    entity.method_31472();
                }
            }
            if (chipsRemoved < woodChipsNeeded && stack.method_7909() == TODDItems.WOOD_CHIPS) {
                toRemove = Math.min(stack.method_7947(), woodChipsNeeded - chipsRemoved);
                stack.method_7934(toRemove);
                chipsRemoved += toRemove;
                if (stack.method_7960()) {
                    entity.method_31472();
                }
            }
            if (grassRemoved < driedGrassNeeded || chipsRemoved < woodChipsNeeded) continue;
            break;
        }
    }
}

