/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.mixin;

import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1613;
import net.minecraft.class_1667;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1667.class})
public class ArrowEntityMixin {
    private static final Random random = new Random();

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V"}, at={@At(value="TAIL")})
    private void onInit(class_1937 world, class_1309 owner, CallbackInfo ci) {
        class_1667 arrow = (class_1667)this;
        if (owner instanceof class_1613) {
            this.modifySkeletonArrow(arrow, (class_1613)owner);
        }
    }

    private void modifySkeletonArrow(class_1667 arrow, class_1613 skeleton) {
        arrow.method_7438(arrow.method_7448() * this.calculateTODDDamageMultiplier(skeleton));
        if (this.isWizardSkeleton(skeleton)) {
            this.applyArrowEffects(arrow, skeleton);
        }
    }

    private double calculateTODDDamageMultiplier(class_1613 skeleton) {
        double multiplier = 1.0;
        if (skeleton.method_5968() != null) {
            double distance = skeleton.method_5739((class_1297)skeleton.method_5968());
            multiplier = this.getDistanceMultiplier(distance);
            long time = skeleton.method_37908().method_8532() % 24000L;
            multiplier *= this.getNightMultiplier(time);
            multiplier *= this.getAccuracyMultiplier(skeleton);
        }
        return multiplier;
    }

    private double getDistanceMultiplier(double distance) {
        if (distance <= 4.0) {
            return 0.5;
        }
        if (distance <= 8.0) {
            return 0.8;
        }
        if (distance <= 16.0) {
            return 1.0;
        }
        if (distance <= 20.0) {
            return 1.2;
        }
        if (distance <= 24.0) {
            return 1.5;
        }
        return 2.0;
    }

    private double getNightMultiplier(long time) {
        if (time < 1000L) {
            return 1.0;
        }
        if (time < 7000L) {
            return 1.1;
        }
        if (time < 13000L) {
            return 1.2;
        }
        return 1.3;
    }

    private double getAccuracyMultiplier(class_1613 skeleton) {
        long time;
        double multiplier = 0.95;
        if (skeleton.method_5968() != null) {
            if (skeleton.method_5968().method_24828()) {
                multiplier *= 1.25;
            }
            if (skeleton.method_5968().method_5624()) {
                multiplier *= 0.95;
            }
            if (skeleton.method_23318() > skeleton.method_5968().method_23318() + 2.0) {
                multiplier *= 1.25;
            }
        }
        if ((time = skeleton.method_37908().method_8532() % 24000L) > 13000L || time < 1000L) {
            multiplier *= 1.15;
        }
        if (skeleton.method_37908().method_8419()) {
            multiplier *= 0.8;
        }
        return multiplier;
    }

    private boolean isWizardSkeleton(class_1613 skeleton) {
        int nightsSurvived = (int)(skeleton.method_37908().method_8532() / 24000L);
        return nightsSurvived >= 5 && random.nextDouble() < 0.3;
    }

    private void applyArrowEffects(class_1667 arrow, class_1613 skeleton) {
        int effectRoll = random.nextInt(4);
        switch (effectRoll) {
            case 0: {
                arrow.method_7463(new class_1293(class_1294.field_5899, 200, 0));
                break;
            }
            case 1: {
                arrow.method_7463(new class_1293(class_1294.field_5909, 160, 1));
                break;
            }
            case 2: {
                arrow.method_7463(new class_1293(class_1294.field_5911, 240, 0));
                break;
            }
            case 3: {
                arrow.method_5639(5);
            }
        }
    }
}

