/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.mixin;

import com.ferrum.todd.hunger.FoodBalanceManager;
import com.ferrum.todd.item.TODDItems;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3489;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1792.class})
public class FoodItemMixin {
    @Inject(method={"finishUsing"}, at={@At(value="HEAD")})
    private void onFinishUsing(class_1799 stack, class_1937 world, class_1309 user, CallbackInfoReturnable<class_1799> cir) {
        if (user instanceof class_1657) {
            class_4174 foodComponent;
            class_1657 player = (class_1657)user;
            if (stack.method_19267() && (foodComponent = stack.method_7909().method_19264()) != null) {
                FoodBalanceManager.FoodType foodType = this.determineFoodType(stack);
                int points = this.calculateFoodPoints(foodComponent);
                FoodBalanceManager.addFoodPoints(player, foodType, points);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77+" + points + " " + this.getFoodTypeName(foodType) + " satiety")), true);
            }
        }
    }

    private FoodBalanceManager.FoodType determineFoodType(class_1799 stack) {
        String itemName = stack.method_7909().toString().toLowerCase();
        if (itemName.contains("porkchop") || itemName.contains("beef") || itemName.contains("chicken") || itemName.contains("mutton") || itemName.contains("rabbit") || itemName.contains("cod") || itemName.contains("salmon") || itemName.contains("tropical_fish") || itemName.contains("pufferfish") || itemName.contains("rotten_flesh") || itemName.contains("spider_eye")) {
            return FoodBalanceManager.FoodType.MEAT;
        }
        if (itemName.contains("potato") || itemName.contains("carrot") || itemName.contains("beetroot") || itemName.contains("kelp") || itemName.contains("dried_kelp") || itemName.contains("cactus") || itemName.contains("sea_pickle") || itemName.contains("bamboo")) {
            return FoodBalanceManager.FoodType.VEGETABLE;
        }
        if (itemName.contains("apple") || itemName.contains("berry") || itemName.contains("melon") || itemName.contains("chorus_fruit") || itemName.contains("sweet_berries") || itemName.contains("glow_berries")) {
            return FoodBalanceManager.FoodType.FRUIT;
        }
        if (itemName.contains("bread") || itemName.contains("cake") || itemName.contains("cookie") || itemName.contains("pumpkin_pie") || itemName.contains("wheat")) {
            return FoodBalanceManager.FoodType.FLOUR;
        }
        if (itemName.contains("mushroom") || itemName.contains("suspicious_stew") || stack.method_31573(class_3489.field_20344) || itemName.contains("sugar") || itemName.contains("honey") || itemName.contains("egg")) {
            return FoodBalanceManager.FoodType.HERBAL;
        }
        if (stack.method_7909() == TODDItems.TODD_APPLE) {
            return FoodBalanceManager.FoodType.FRUIT;
        }
        return FoodBalanceManager.FoodType.VEGETABLE;
    }

    private int calculateFoodPoints(class_4174 foodComponent) {
        return foodComponent.method_19230() + (int)(foodComponent.method_19231() * 2.0f);
    }

    private String getFoodTypeName(FoodBalanceManager.FoodType type) {
        switch (type) {
            case MEAT: {
                return "\u00a7cmeat";
            }
            case VEGETABLE: {
                return "\u00a7avegetable";
            }
            case FRUIT: {
                return "\u00a7efruit";
            }
            case HERBAL: {
                return "\u00a7bherbal";
            }
            case FLOUR: {
                return "\u00a7fflour";
            }
        }
        return "unknown";
    }
}

