/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.mixin;

import com.ferrum.todd.starvation.StarvationEffectManager;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
public class HungerManagerMixin {
    @Shadow
    private int field_7756;
    @Shadow
    private float field_7753;
    @Shadow
    private float field_7752;
    @Shadow
    private int field_7755;
    @Unique
    private int todd$lastFoodLevel = 20;
    @Unique
    private static final int TODD_MAX_FOOD = 6;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        int hiddenSlots = 7;
        this.field_7756 = Math.min(this.field_7756, 6 + hiddenSlots);
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void onUpdate(class_1657 player, CallbackInfo ci) {
        int hiddenSlots;
        StarvationEffectManager.updateStarvationEffects(player);
        if (this.field_7756 != this.todd$lastFoodLevel) {
            StarvationEffectManager.checkFoodComa(player, this.todd$lastFoodLevel, this.field_7756);
            this.todd$lastFoodLevel = this.field_7756;
        }
        if (this.field_7756 > 6 + (hiddenSlots = StarvationEffectManager.getHiddenFoodSlots(player))) {
            this.field_7756 = 6 + hiddenSlots;
        }
        if (StarvationEffectManager.getStarvationLevel(player) > 0) {
            this.field_7755 = 0;
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    private void onAddFood(int food, float saturationModifier, CallbackInfo ci) {
        this.todd$lastFoodLevel = this.field_7756;
    }

    @Inject(method={"addExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddExhaustion(float exhaustion, CallbackInfo ci) {
        if (exhaustion > 0.01f) {
            this.field_7752 += exhaustion * 5.0f;
            ci.cancel();
        }
    }

    @Unique
    public int getVisibleFoodLevel(class_1657 player) {
        int hiddenSlots = StarvationEffectManager.getHiddenFoodSlots(player);
        int internalFood = this.field_7756 - hiddenSlots;
        return Math.max(0, Math.min(6, internalFood));
    }

    @Unique
    public void setVisibleFoodLevel(class_1657 player, int level) {
        int hiddenSlots = StarvationEffectManager.getHiddenFoodSlots(player);
        this.field_7756 = Math.max(hiddenSlots, Math.min(hiddenSlots + 6, level + hiddenSlots));
    }
}

