/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.mixin;

import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1628.class})
public abstract class SpiderEntityMixin {
    @Unique
    private static final int POISON_RANGE = 20;
    @Unique
    private static final int POISON_COOLDOWN = 100;
    @Unique
    private static final int WEB_COOLDOWN = 200;
    @Unique
    private static final int RAGE_DURATION = 300;
    @Unique
    private static final int TELEPORT_COOLDOWN = 400;
    @Unique
    private static final double TELEPORT_RANGE = 8.0;
    @Unique
    private int todd$poisonCooldown = 0;
    @Unique
    private int todd$webCooldown = 0;
    @Unique
    private int todd$rageCooldown = 0;
    @Unique
    private int todd$teleportCooldown = 0;
    @Unique
    private boolean todd$isEnraged = false;
    @Unique
    private int todd$enrageTicks = 0;
    @Unique
    private class_1309 todd$lastTarget = null;
    @Unique
    private static final UUID RAGE_SPEED_BOOST_ID = UUID.fromString("B9766B59-8566-4402-BC1F-2EE2A276D801");
    @Unique
    private static final UUID RAGE_DAMAGE_BOOST_ID = UUID.fromString("B9766B59-8566-4402-BC1F-2EE2A276D802");

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void todd$onTick(CallbackInfo ci) {
        class_1628 spider = (class_1628)this;
        class_1937 world = spider.method_37908();
        if (!spider.method_29504()) {
            this.todd$updateCooldowns();
            this.todd$updateRageState(spider);
            if (!world.field_9236) {
                this.todd$checkSpecialAttacks(spider);
                this.todd$checkTeleport(spider);
            }
            if (this.todd$isEnraged && world.field_9236) {
                this.todd$spawnRageParticles(spider);
            }
        }
    }

    @Unique
    private boolean todd$shouldAttackPlayer(class_1657 player) {
        return !player.method_7337() && !player.method_7325();
    }

    @Unique
    private void todd$updateCooldowns() {
        if (this.todd$poisonCooldown > 0) {
            --this.todd$poisonCooldown;
        }
        if (this.todd$webCooldown > 0) {
            --this.todd$webCooldown;
        }
        if (this.todd$rageCooldown > 0) {
            --this.todd$rageCooldown;
        }
        if (this.todd$teleportCooldown > 0) {
            --this.todd$teleportCooldown;
        }
    }

    @Unique
    private void todd$updateRageState(class_1628 spider) {
        if (this.todd$isEnraged) {
            --this.todd$enrageTicks;
            if (this.todd$enrageTicks <= 0) {
                this.todd$deactivateRage(spider);
            }
        }
    }

    @Unique
    private void todd$checkSpecialAttacks(class_1628 spider) {
        class_1937 world = spider.method_37908();
        class_1657 target = world.method_18460((class_1297)spider, 20.0);
        if (target != null && spider.method_6057((class_1297)target)) {
            if (!this.todd$shouldAttackPlayer(target)) {
                return;
            }
            this.todd$lastTarget = target;
            if (this.todd$poisonCooldown <= 0 && (double)spider.method_5739((class_1297)target) > 4.0) {
                this.todd$shootPoisonSnowball(spider, (class_1309)target);
            }
            if (this.todd$webCooldown <= 0 && (double)spider.method_5739((class_1297)target) < 10.0) {
                this.todd$shootWebSnowball(spider, (class_1309)target);
            }
        }
    }

    @Unique
    private void todd$checkTeleport(class_1628 spider) {
        if (this.todd$teleportCooldown <= 0 && this.todd$lastTarget != null && !spider.method_6510()) {
            class_1657 player;
            class_1309 class_13092 = this.todd$lastTarget;
            if (class_13092 instanceof class_1657 && !this.todd$shouldAttackPlayer(player = (class_1657)class_13092)) {
                return;
            }
            if ((double)spider.method_5739((class_1297)this.todd$lastTarget) > 12.0 && spider.method_6051().method_43057() < 0.1f) {
                this.todd$teleportBehindTarget(spider, this.todd$lastTarget);
            }
        }
    }

    @Unique
    private void todd$shootPoisonSnowball(class_1628 spider, class_1309 target) {
        final class_1937 world = spider.method_37908();
        class_1680 snowball = new class_1680(world, (class_1309)spider){

            protected void method_7454(class_3966 entityHitResult) {
                class_1309 living;
                super.method_7454(entityHitResult);
                class_1297 class_12972 = entityHitResult.method_17782();
                if (class_12972 instanceof class_1309 && !(living = (class_1309)class_12972).method_5655()) {
                    class_1657 player;
                    if (living instanceof class_1657 && !SpiderEntityMixin.this.todd$shouldAttackPlayer(player = (class_1657)living)) {
                        return;
                    }
                    living.method_6092(new class_1293(class_1294.field_5911, 200, 1));
                    living.method_6092(new class_1293(class_1294.field_5909, 200, 1));
                    living.method_6092(new class_1293(class_1294.field_5899, 200, 1));
                    if (SpiderEntityMixin.this.todd$isEnraged) {
                        living.method_6092(new class_1293(class_1294.field_5919, 100, 0));
                        living.method_6092(new class_1293(class_1294.field_5916, 100, 0));
                    }
                    world.method_8396(null, living.method_24515(), class_3417.field_14863, class_3419.field_15251, 0.8f, 0.8f);
                    if (world.field_9236) {
                        for (int i = 0; i < 12; ++i) {
                            double offsetX = (world.field_9229.method_43058() - 0.5) * 0.8;
                            double offsetY = world.field_9229.method_43058() * 1.8;
                            double offsetZ = (world.field_9229.method_43058() - 0.5) * 0.8;
                            world.method_8406((class_2394)class_2398.field_11246, living.method_23317() + offsetX, living.method_23318() + offsetY, living.method_23321() + offsetZ, 0.0, 0.1, 0.0);
                        }
                    }
                }
            }
        };
        this.todd$shootProjectile(spider, target, snowball, "poison");
        this.todd$poisonCooldown = this.todd$isEnraged ? 50 : 100;
    }

    @Unique
    private void todd$shootWebSnowball(class_1628 spider, class_1309 target) {
        final class_1937 world = spider.method_37908();
        class_1680 snowball = new class_1680(world, (class_1309)spider){

            protected void method_7454(class_3966 entityHitResult) {
                class_1309 living;
                super.method_7454(entityHitResult);
                class_1297 class_12972 = entityHitResult.method_17782();
                if (class_12972 instanceof class_1309 && !(living = (class_1309)class_12972).method_5655()) {
                    class_1657 player;
                    if (living instanceof class_1657 && !SpiderEntityMixin.this.todd$shouldAttackPlayer(player = (class_1657)living)) {
                        return;
                    }
                    class_2338 playerPos = living.method_24515();
                    if (world.method_8320(playerPos).method_26215()) {
                        world.method_8501(playerPos, class_2246.field_10343.method_9564());
                    }
                    living.method_6092(new class_1293(class_1294.field_5909, 100, 3));
                    living.method_6092(new class_1293(class_1294.field_5901, 100, 1));
                    if (world.field_9236) {
                        for (int i = 0; i < 15; ++i) {
                            double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
                            double offsetY = world.field_9229.method_43058() * 2.0;
                            double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
                            world.method_8406((class_2394)class_2398.field_23956, living.method_23317() + offsetX, living.method_23318() + offsetY, living.method_23321() + offsetZ, 0.0, 0.05, 0.0);
                        }
                    }
                }
            }

            protected void method_7488(class_239 hitResult) {
                class_2338 hitPos;
                super.method_7488(hitResult);
                if (hitResult.method_17783() == class_239.class_240.field_1332 && !world.field_9236 && world.method_8320(hitPos = ((class_3965)hitResult).method_17777().method_10093(((class_3965)hitResult).method_17780())).method_26215()) {
                    world.method_8501(hitPos, class_2246.field_10343.method_9564());
                }
            }
        };
        this.todd$shootProjectile(spider, target, snowball, "web");
        this.todd$webCooldown = this.todd$isEnraged ? 100 : 200;
    }

    @Unique
    private void todd$shootProjectile(class_1628 spider, class_1309 target, class_1680 snowball, String type) {
        float speed;
        class_1937 world = spider.method_37908();
        class_243 spiderPos = spider.method_33571();
        class_243 targetPos = target.method_33571();
        class_243 direction = targetPos.method_1020(spiderPos).method_1029();
        double spread = this.todd$isEnraged ? 0.02 : 0.05;
        double velX = direction.field_1352 + (spider.method_6051().method_43058() - 0.5) * spread;
        double velY = direction.field_1351 + (spider.method_6051().method_43058() - 0.5) * spread;
        double velZ = direction.field_1350 + (spider.method_6051().method_43058() - 0.5) * spread;
        float f = speed = this.todd$isEnraged ? 1.8f : 1.5f;
        if (type.equals("web")) {
            speed = 1.2f;
        }
        snowball.method_33574(spiderPos);
        snowball.method_7485(velX, velY, velZ, speed, 1.0f);
        world.method_8649((class_1297)snowball);
        if (type.equals("poison")) {
            world.method_8396(null, spider.method_24515(), class_3417.field_14657, class_3419.field_15251, 0.6f, 1.2f);
        } else {
            world.method_8396(null, spider.method_24515(), class_3417.field_15170, class_3419.field_15251, 0.7f, 0.9f);
        }
    }

    @Unique
    private void todd$activateRage(class_1628 spider) {
        this.todd$isEnraged = true;
        this.todd$enrageTicks = 300;
        class_1324 speedAttribute = spider.method_5996(class_5134.field_23719);
        class_1324 damageAttribute = spider.method_5996(class_5134.field_23721);
        if (speedAttribute != null) {
            speedAttribute.method_26835(new class_1322(RAGE_SPEED_BOOST_ID, "Rage speed boost", 0.3, class_1322.class_1323.field_6331));
        }
        if (damageAttribute != null) {
            damageAttribute.method_26835(new class_1322(RAGE_DAMAGE_BOOST_ID, "Rage damage boost", 2.0, class_1322.class_1323.field_6328));
        }
        class_1937 world = spider.method_37908();
        world.method_8396(null, spider.method_24515(), class_3417.field_15170, class_3419.field_15251, 2.0f, 0.6f);
        this.todd$poisonCooldown = 0;
        this.todd$webCooldown = 0;
    }

    @Unique
    private void todd$deactivateRage(class_1628 spider) {
        this.todd$isEnraged = false;
        class_1324 speedAttribute = spider.method_5996(class_5134.field_23719);
        class_1324 damageAttribute = spider.method_5996(class_5134.field_23721);
        if (speedAttribute != null) {
            speedAttribute.method_6200(RAGE_SPEED_BOOST_ID);
        }
        if (damageAttribute != null) {
            damageAttribute.method_6200(RAGE_DAMAGE_BOOST_ID);
        }
        spider.method_6092(new class_1293(class_1294.field_5909, 100, 1));
        spider.method_6092(new class_1293(class_1294.field_5911, 100, 0));
    }

    @Unique
    private void todd$teleportBehindTarget(class_1628 spider, class_1309 target) {
        class_243 targetPos = target.method_19538();
        class_243 lookVec = target.method_5828(1.0f).method_1029();
        class_243 teleportPos = targetPos.method_1020(lookVec.method_1021(8.0));
        class_2338 checkPos = class_2338.method_49638((class_2374)teleportPos);
        class_1937 world = spider.method_37908();
        if (world.method_8320(checkPos).method_26215() && world.method_8320(checkPos.method_10084()).method_26215()) {
            spider.method_20620(teleportPos.field_1352, teleportPos.field_1351, teleportPos.field_1350);
            world.method_8396(null, spider.method_24515(), class_3417.field_14879, class_3419.field_15251, 1.0f, 1.2f);
            if (world.field_9236) {
                for (int i = 0; i < 10; ++i) {
                    world.method_8406((class_2394)class_2398.field_11214, spider.method_23317() + (world.field_9229.method_43058() - 0.5), spider.method_23318() + world.field_9229.method_43058(), spider.method_23321() + (world.field_9229.method_43058() - 0.5), 0.0, 0.0, 0.0);
                }
            }
            this.todd$teleportCooldown = 400;
        }
    }

    @Unique
    private void todd$spawnRageParticles(class_1628 spider) {
        class_1937 world = spider.method_37908();
        for (int i = 0; i < 2; ++i) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * (double)spider.method_17681();
            double offsetY = world.field_9229.method_43058() * (double)spider.method_17682();
            double offsetZ = (world.field_9229.method_43058() - 0.5) * (double)spider.method_17681();
            world.method_8406((class_2394)class_2398.field_11240, spider.method_23317() + offsetX, spider.method_23318() + offsetY, spider.method_23321() + offsetZ, 0.0, 0.05, 0.0);
        }
    }
}

