/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.mixin.client;

import com.ferrum.todd.block.TODDStoneBlocks;
import com.ferrum.todd.effect.EyeEatingTextManager;
import com.ferrum.todd.effect.EyeEffectManager;
import com.ferrum.todd.item.FlintKnifeItem;
import com.ferrum.todd.item.ObsidianScalpelItem;
import com.ferrum.todd.item.SharpStickItem;
import com.ferrum.todd.item.ShortSharpStickItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class InGameHudMixin {
    @Shadow
    @Final
    private class_310 field_2035;
    private static final Map<UUID, Long> eyeEffectStartTimes = new HashMap<UUID, Long>();
    private static final long MESSAGE_DURATION = 600L;
    private long gameStartTime = -1L;

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 context, float tickDelta, CallbackInfo ci) {
        class_2338 lookingAt;
        boolean isUsingKnife;
        if (this.field_2035.field_1724 == null) {
            return;
        }
        EyeEatingTextManager.tick();
        class_1799 mainHandStack = this.field_2035.field_1724.method_6047();
        int sharpStickDuration = SharpStickItem.getHoldDuration(this.field_2035.field_1724.method_5667());
        int shortSharpStickDuration = ShortSharpStickItem.getHoldDuration(this.field_2035.field_1724.method_5667());
        int knifeHoldDuration = FlintKnifeItem.getHoldDuration(this.field_2035.field_1724.method_5667());
        int knifeRequiredTime = FlintKnifeItem.getRequiredTime(this.field_2035.field_1724.method_5667());
        boolean bl = isUsingKnife = this.field_2035.field_1724.method_6115() && mainHandStack.method_7909() instanceof FlintKnifeItem && knifeHoldDuration > 0;
        if (isUsingKnife) {
            this.renderFlintKnifeTimer(context, knifeHoldDuration, knifeRequiredTime);
        } else if (sharpStickDuration > 0) {
            this.renderSharpStickTimer(context, sharpStickDuration, false);
        } else if (shortSharpStickDuration > 0) {
            this.renderSharpStickTimer(context, shortSharpStickDuration, true);
        }
        int holdDuration = ObsidianScalpelItem.getHoldDuration(this.field_2035.field_1724.method_5667());
        if (holdDuration > 0 && holdDuration < 60) {
            this.renderScalpelTimer(context, holdDuration);
        }
        if (this.shouldRenderEyeEffect()) {
            this.renderEyeEffect(context);
        }
        if ((lookingAt = this.getTargetedBlockPos()) != null) {
            this.renderLeatherProcessingProgress(context, lookingAt);
        }
        this.renderVersionText(context);
        this.renderTimeDisplay(context);
    }

    private void renderTimeDisplay(class_332 context) {
        if (this.field_2035.field_1687 == null || this.field_2035.field_1724 == null) {
            return;
        }
        if (this.gameStartTime == -1L) {
            this.gameStartTime = System.currentTimeMillis();
        }
        long worldTime = this.field_2035.field_1687.method_8510();
        long minecraftDays = worldTime / 24000L;
        long minecraftTimeOfDay = worldTime % 24000L;
        long minecraftHours = minecraftTimeOfDay / 1000L;
        long minecraftMinutes = minecraftTimeOfDay % 1000L * 60L / 1000L;
        String minecraftTime = String.format("Day: %d, Time: %02d:%02d", minecraftDays, minecraftHours, minecraftMinutes);
        long currentRealTime = System.currentTimeMillis();
        long playTimeMillis = currentRealTime - this.gameStartTime;
        long playTimeHours = playTimeMillis / 3600000L;
        long playTimeMinutes = playTimeMillis % 3600000L / 60000L;
        String realPlayTime = String.format("Play Time: %02d:%02d", playTimeHours, playTimeMinutes);
        int x = 5;
        int y = 5;
        context.method_51433(this.field_2035.field_1772, minecraftTime, x, y, 0xFFFFFF, false);
        context.method_51433(this.field_2035.field_1772, realPlayTime, x, y + 10, 0xAAAAAA, false);
    }

    private void renderVersionText(class_332 context) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        String versionText = "version: pre-alpha v0.0.6";
        int textWidth = this.field_2035.field_1772.method_1727(versionText);
        int x = screenWidth - textWidth - 5;
        int y = screenHeight - 10;
        context.method_51433(this.field_2035.field_1772, versionText, x, y, 0xFFFFFF, false);
    }

    private class_2338 getTargetedBlockPos() {
        if (this.field_2035.field_1765 != null && this.field_2035.field_1765.method_17783() == class_239.class_240.field_1332) {
            return ((class_3965)this.field_2035.field_1765).method_17777();
        }
        return null;
    }

    private void renderLeatherProcessingProgress(class_332 context, class_2338 pos) {
        Long startTime = TODDStoneBlocks.getProcessingTimer(pos);
        TODDStoneBlocks.ProcessType processType = TODDStoneBlocks.getProcessType(pos);
        if (startTime != null && processType != null && this.field_2035.field_1687 != null && this.field_2035.field_1724 != null) {
            long requiredTicks;
            long currentTime = this.field_2035.field_1687.method_8510();
            long elapsedTicks = currentTime - startTime;
            class_5250 processText = switch (processType) {
                case TODDStoneBlocks.ProcessType.SCRAPING_RAW_LEATHER -> {
                    requiredTicks = 1800L;
                    yield class_2561.method_43469((String)"gui.todd.leather_scraping", (Object[])new Object[]{0});
                }
                case TODDStoneBlocks.ProcessType.PROCESSING_TANNED_LEATHER -> {
                    requiredTicks = 600L;
                    yield class_2561.method_43469((String)"gui.todd.leather_processing", (Object[])new Object[]{0});
                }
                default -> {
                    requiredTicks = 600L;
                    yield class_2561.method_43469((String)"gui.todd.processing", (Object[])new Object[]{0});
                }
            };
            int progress = (int)Math.min(100.0f, (float)elapsedTicks / (float)requiredTicks * 100.0f);
            if (progress >= 100) {
                TODDStoneBlocks.completeLeatherProcessing((class_1937)this.field_2035.field_1687, pos, (class_1657)this.field_2035.field_1724, processType);
                return;
            }
            int screenWidth = context.method_51421();
            int screenHeight = context.method_51443();
            int x = screenWidth / 2 - 50;
            int y = screenHeight - 80;
            context.method_25294(x, y, x + 100, y + 10, -16777216);
            context.method_25294(x, y, x + progress, y + 10, -16711936);
            context.method_25294(x, y, x + 100, y + 1, -1);
            context.method_25294(x, y + 9, x + 100, y + 10, -1);
            context.method_25294(x, y, x + 1, y + 10, -1);
            context.method_25294(x + 99, y, x + 100, y + 10, -1);
            processText = class_2561.method_43469((String)processText.getString().replace("%s", ""), (Object[])new Object[]{progress});
            context.method_51439(this.field_2035.field_1772, (class_2561)processText, x, y - 12, 0xFFFFFF, true);
            long remainingSeconds = Math.max(0L, (requiredTicks - elapsedTicks) / 20L);
            class_5250 timeText = class_2561.method_43469((String)"gui.todd.remaining_time", (Object[])new Object[]{remainingSeconds});
            context.method_51439(this.field_2035.field_1772, (class_2561)timeText, x + 101, y, 0xFFFFFF, true);
        }
    }

    private void renderScalpelTimer(class_332 context, int holdDuration) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int x = screenWidth / 2 - 50;
        int y = screenHeight - 40;
        int progressWidth = (int)((float)holdDuration / 60.0f * 100.0f);
        context.method_25294(x, y, x + 100, y + 8, -16777216);
        context.method_25294(x, y, x + progressWidth, y + 8, -65536);
        context.method_25294(x, y, x + 100, y + 1, -1);
        context.method_25294(x, y + 7, x + 100, y + 8, -1);
        context.method_25294(x, y, x + 1, y + 8, -1);
        context.method_25294(x + 99, y, x + 100, y + 8, -1);
        class_5250 text = class_2561.method_43469((String)"gui.todd.scalpel_timer", (Object[])new Object[]{holdDuration});
        context.method_51439(this.field_2035.field_1772, (class_2561)text, x + 101, y - 1, 0xFFFFFF, true);
    }

    private void renderFlintKnifeTimer(class_332 context, int holdDuration, int requiredTime) {
        boolean isUsingKnife;
        if (this.field_2035.field_1724 == null || this.field_2035.field_1687 == null) {
            return;
        }
        class_1799 mainHandStack = this.field_2035.field_1724.method_6047();
        boolean bl = isUsingKnife = this.field_2035.field_1724.method_6115() && mainHandStack.method_7909() instanceof FlintKnifeItem && holdDuration > 0;
        if (isUsingKnife && requiredTime > 0) {
            int progressColor;
            int screenWidth = context.method_51421();
            int screenHeight = context.method_51443();
            int x = screenWidth / 2 - 50;
            int y = screenHeight - 60;
            float progress = Math.min(1.0f, (float)holdDuration / (float)requiredTime);
            int progressWidth = (int)(progress * 100.0f);
            context.method_25294(x, y, x + 100, y + 8, -16777216);
            if (progress < 0.5f) {
                red = 255;
                green = (int)(255.0f * (progress * 2.0f));
                progressColor = 0xFF000000 | red << 16 | green << 8;
            } else {
                red = (int)(255.0f * (2.0f - progress * 2.0f));
                green = 255;
                progressColor = 0xFF000000 | red << 16 | green << 8;
            }
            context.method_25294(x, y, x + progressWidth, y + 8, progressColor);
            context.method_25294(x, y, x + 100, y + 1, -1);
            context.method_25294(x, y + 7, x + 100, y + 8, -1);
            context.method_25294(x, y, x + 1, y + 8, -1);
            context.method_25294(x + 99, y, x + 100, y + 8, -1);
            class_5250 toolText = class_2561.method_43469((String)"gui.todd.flint_knife_timer", (Object[])new Object[]{holdDuration, requiredTime});
            context.method_51439(this.field_2035.field_1772, (class_2561)toolText, x, y - 12, 0xFFFFFF, true);
            int percent = (int)(progress * 100.0f);
            class_5250 percentText = class_2561.method_43469((String)"gui.todd.percentage", (Object[])new Object[]{percent});
            context.method_51439(this.field_2035.field_1772, (class_2561)percentText, x + 101, y - 1, 0xFFFFFF, true);
        }
    }

    private boolean shouldRenderEyeEffect() {
        if (this.field_2035.field_1724 == null) {
            return false;
        }
        return EyeEffectManager.hasLostEye((class_1657)this.field_2035.field_1724);
    }

    private void renderEyeEffect(class_332 context) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int blackWidth = (int)((float)screenWidth * 0.4f);
        context.method_25294(0, 0, blackWidth, screenHeight, -16777216);
        int gradientWidth = 50;
        for (int i = 0; i < gradientWidth; ++i) {
            float progress = (float)i / (float)gradientWidth;
            int alpha = (int)(255.0f * (1.0f - progress * progress));
            int color = alpha << 24 | 0;
            context.method_25294(blackWidth + i, 0, blackWidth + i + 1, screenHeight, color);
        }
        if (this.shouldShowWarningText()) {
            this.renderWarningText(context, blackWidth, screenHeight);
        }
    }

    private boolean shouldShowWarningText() {
        UUID playerId = this.field_2035.field_1724.method_5667();
        long currentTime = this.field_2035.field_1724.method_37908().method_8510();
        if (!eyeEffectStartTimes.containsKey(playerId)) {
            eyeEffectStartTimes.put(playerId, currentTime);
            return true;
        }
        long startTime = eyeEffectStartTimes.get(playerId);
        return currentTime - startTime < 600L;
    }

    private void renderWarningText(class_332 context, int blackWidth, int screenHeight) {
        class_5250 warningText = class_2561.method_43471((String)"effect.todd.eye_missing");
        int textX = blackWidth / 2 - this.field_2035.field_1772.method_27525((class_5348)warningText) / 2;
        int textY = screenHeight / 2 - 10;
        context.method_51439(this.field_2035.field_1772, (class_2561)warningText, textX, textY, 0xFFFFFF, true);
        class_5250 subText = class_2561.method_43471((String)"effect.todd.permanent_damage");
        int subTextX = blackWidth / 2 - this.field_2035.field_1772.method_27525((class_5348)subText) / 2;
        int subTextY = screenHeight / 2 + 10;
        context.method_51439(this.field_2035.field_1772, (class_2561)subText, subTextX, subTextY, 0xFF6666, true);
        String symbol = "\u00a74\u26b0";
        int symbolX = blackWidth / 2 - this.field_2035.field_1772.method_1727(symbol) / 2;
        int symbolY = screenHeight / 2 - 30;
        context.method_51433(this.field_2035.field_1772, symbol, symbolX, symbolY, 0xFFFFFF, true);
    }

    private void renderSharpStickTimer(class_332 context, int holdDuration, boolean isShort) {
        int progressColor;
        class_5250 toolText;
        int requiredTime;
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int x = screenWidth / 2 - 50;
        int y = screenHeight - 60;
        UUID playerId = this.field_2035.field_1724.method_5667();
        if (isShort) {
            requiredTime = ShortSharpStickItem.getRequiredTime(playerId);
            toolText = class_2561.method_43469((String)"gui.todd.short_sharp_stick_timer", (Object[])new Object[]{holdDuration});
        } else {
            requiredTime = SharpStickItem.getRequiredTime(playerId);
            toolText = class_2561.method_43469((String)"gui.todd.sharp_stick_timer", (Object[])new Object[]{holdDuration});
        }
        float progress = Math.min(1.0f, (float)holdDuration / (float)requiredTime);
        int progressWidth = (int)(progress * 100.0f);
        context.method_25294(x, y, x + 100, y + 8, -16777216);
        if (progress < 0.5f) {
            red = 255;
            green = (int)(255.0f * (progress * 2.0f));
            progressColor = 0xFF000000 | red << 16 | green << 8;
        } else {
            red = (int)(255.0f * (2.0f - progress * 2.0f));
            green = 255;
            progressColor = 0xFF000000 | red << 16 | green << 8;
        }
        context.method_25294(x, y, x + progressWidth, y + 8, progressColor);
        context.method_25294(x, y, x + 100, y + 1, -1);
        context.method_25294(x, y + 7, x + 100, y + 8, -1);
        context.method_25294(x, y, x + 1, y + 8, -1);
        context.method_25294(x + 99, y, x + 100, y + 8, -1);
        context.method_51439(this.field_2035.field_1772, (class_2561)toolText, x, y - 12, 0xFFFFFF, true);
        int percent = (int)(progress * 100.0f);
        class_5250 percentText = class_2561.method_43469((String)"gui.todd.percentage", (Object[])new Object[]{percent});
        context.method_51439(this.field_2035.field_1772, (class_2561)percentText, x + 101, y - 1, 0xFFFFFF, true);
    }
}

