/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.skeleton;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.class_1304;
import net.minecraft.class_1613;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5134;

public class SkeletonStatsManager {
    private static final Random random = new Random();
    public static final double BASE_HEALTH = 24.0;
    public static final double TODD_HEALTH_MULTIPLIER = 1.2;
    public static final double BASE_SPEED = 0.28;
    private static final double[][] ARMOR_CHANCES = new double[][]{{0.15, 1.0}, {0.25, 2.0}, {0.4, 3.0}, {0.6, 4.0}};
    private static final ArmorTier[] ARMOR_TIERS = new ArmorTier[]{new ArmorTier(class_1802.field_8370, class_1802.field_8570, class_1802.field_8577, class_1802.field_8267), new ArmorTier(class_1802.field_8753, class_1802.field_8416, class_1802.field_8678, class_1802.field_8862), new ArmorTier(class_1802.field_8313, class_1802.field_8218, class_1802.field_8873, class_1802.field_8283), new ArmorTier(class_1802.field_8660, class_1802.field_8396, class_1802.field_8523, class_1802.field_8743), new ArmorTier(class_1802.field_8285, class_1802.field_8348, class_1802.field_8058, class_1802.field_8805)};

    public static void applySkeletonStats(class_1613 skeleton, class_1937 world) {
        if (world instanceof class_3218) {
            SkeletonStatsManager.applyBaseStats(skeleton);
            SkeletonStatsManager.applyEquipment(skeleton, world);
            SkeletonStatsManager.applySpecialAbilities(skeleton, world);
        }
    }

    private static void applyBaseStats(class_1613 skeleton) {
        double health = 28.799999999999997;
        skeleton.method_6033((float)health);
        skeleton.method_5996(class_5134.field_23719).method_6192(0.28);
        skeleton.method_5996(class_5134.field_23717).method_6192(36.0);
    }

    private static void applyEquipment(class_1613 skeleton, class_1937 world) {
        long time = world.method_8532() % 24000L;
        int nightsSurvived = (int)(world.method_8532() / 24000L);
        int armorLevel = SkeletonStatsManager.getArmorLevelByTime(time);
        double[] armorChance = ARMOR_CHANCES[armorLevel];
        if (random.nextDouble() < armorChance[0]) {
            SkeletonStatsManager.equipArmor(skeleton, (int)armorChance[1], nightsSurvived);
        }
        SkeletonStatsManager.equipBow(skeleton, time, nightsSurvived);
        SkeletonStatsManager.applyTimeEffects(skeleton, time);
    }

    private static int getArmorLevelByTime(long time) {
        if (time < 1000L) {
            return 0;
        }
        if (time < 7000L) {
            return 1;
        }
        if (time < 13000L) {
            return 2;
        }
        return 3;
    }

    private static void equipArmor(class_1613 skeleton, int parts, int nightsSurvived) {
        ArmorTier tier = SkeletonStatsManager.getRandomArmorTier(nightsSurvived);
        if (parts >= 1) {
            skeleton.method_5673(class_1304.field_6166, new class_1799((class_1935)tier.boots));
        }
        if (parts >= 2) {
            skeleton.method_5673(class_1304.field_6172, new class_1799((class_1935)tier.leggings));
        }
        if (parts >= 3) {
            skeleton.method_5673(class_1304.field_6174, new class_1799((class_1935)tier.chestplate));
        }
        if (parts >= 4) {
            skeleton.method_5673(class_1304.field_6169, new class_1799((class_1935)tier.helmet));
        }
    }

    private static void equipBow(class_1613 skeleton, long time, int nightsSurvived) {
        BowType bowType = SkeletonStatsManager.getRandomBowType(time, nightsSurvived);
        class_1799 bow = new class_1799((class_1935)class_1802.field_8102);
        if (bowType.enchantment != null) {
            HashMap<class_1887, Integer> enchantments = new HashMap<class_1887, Integer>();
            enchantments.put(bowType.enchantment, bowType.enchantLevel);
            class_1890.method_8214(enchantments, (class_1799)bow);
        }
        skeleton.method_5673(class_1304.field_6173, bow);
    }

    private static BowType getRandomBowType(long time, int nightsSurvived) {
        double roll = random.nextDouble();
        int timeLevel = SkeletonStatsManager.getArmorLevelByTime(time);
        if (nightsSurvived >= 7 && roll < 0.03) {
            return BowType.INFINITY;
        }
        if (nightsSurvived >= 5 && roll < 0.08) {
            return SkeletonStatsManager.getMagicBow();
        }
        if (nightsSurvived >= 3 && roll < 0.15) {
            return BowType.POWER;
        }
        if (timeLevel >= 3 && roll < 0.25) {
            return BowType.FLAME;
        }
        if (timeLevel >= 2 && roll < 0.4) {
            return BowType.PUNCH;
        }
        if (timeLevel >= 1 && roll < 0.6) {
            return BowType.POWER;
        }
        return BowType.NORMAL;
    }

    private static BowType getMagicBow() {
        BowType[] magicBows = new BowType[]{BowType.FLAME, BowType.PUNCH, BowType.POWER};
        return magicBows[random.nextInt(magicBows.length)];
    }

    private static void applyTimeEffects(class_1613 skeleton, long time) {
        int timeLevel = SkeletonStatsManager.getArmorLevelByTime(time);
        switch (timeLevel) {
            case 1: {
                skeleton.method_5996(class_5134.field_23719).method_6192(0.30800000000000005);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private static void applySpecialAbilities(class_1613 skeleton, class_1937 world) {
        int nightsSurvived = (int)(world.method_8532() / 24000L);
        double spawnRoll = random.nextDouble();
        if (nightsSurvived >= 7 && spawnRoll < 0.03) {
            SkeletonStatsManager.makeLegendarySkeleton(skeleton);
        } else if (nightsSurvived >= 5 && spawnRoll < 0.05) {
            SkeletonStatsManager.makeWizardSkeleton(skeleton);
        } else if (nightsSurvived >= 3 && spawnRoll < 0.1) {
            SkeletonStatsManager.makeSniperSkeleton(skeleton);
        }
    }

    private static void makeSniperSkeleton(class_1613 skeleton) {
        skeleton.method_5996(class_5134.field_23717).method_6192(72.0);
    }

    private static void makeWizardSkeleton(class_1613 skeleton) {
    }

    private static void makeLegendarySkeleton(class_1613 skeleton) {
        SkeletonStatsManager.equipArmor(skeleton, 4, 10);
        class_1799 bow = new class_1799((class_1935)class_1802.field_8102);
        HashMap<class_1887, Integer> enchantments = new HashMap<class_1887, Integer>();
        enchantments.put(class_1893.field_9103, 3);
        enchantments.put(class_1893.field_9126, 1);
        enchantments.put(class_1893.field_9116, 2);
        enchantments.put(class_1893.field_9125, 1);
        class_1890.method_8214(enchantments, (class_1799)bow);
        skeleton.method_5673(class_1304.field_6173, bow);
        skeleton.method_6033(43.2f);
        skeleton.method_5996(class_5134.field_23719).method_6192(0.336);
    }

    private static ArmorTier getRandomArmorTier(int nightsSurvived) {
        int maxTier = Math.min(4, nightsSurvived / 2);
        int tier = random.nextInt(maxTier + 1);
        return ARMOR_TIERS[tier];
    }

    private static class ArmorTier {
        public final class_1792 boots;
        public final class_1792 leggings;
        public final class_1792 chestplate;
        public final class_1792 helmet;

        public ArmorTier(class_1792 boots, class_1792 leggings, class_1792 chestplate, class_1792 helmet) {
            this.boots = boots;
            this.leggings = leggings;
            this.chestplate = chestplate;
            this.helmet = helmet;
        }
    }

    public static enum BowType {
        NORMAL(5, 1.0, 0, null),
        POWER(7, 0.9, 1, class_1893.field_9103),
        PUNCH(5, 1.0, 2, class_1893.field_9116),
        FLAME(5, 1.1, 3, class_1893.field_9126),
        INFINITY(6, 0.8, 4, class_1893.field_9125);

        public final int damage;
        public final double chargeTime;
        public final int enchantLevel;
        public final class_1887 enchantment;

        private BowType(int damage, double chargeTime, int enchantLevel, class_1887 enchantment) {
            this.damage = damage;
            this.chargeTime = chargeTime;
            this.enchantLevel = enchantLevel;
            this.enchantment = enchantment;
        }
    }
}

