/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.starvation;

import com.ferrum.todd.effect.FoodComaStatusEffect;
import com.ferrum.todd.effect.StarvationStatusEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class StarvationEffectManager {
    private static final Map<UUID, StarvationData> playerStarvationData = new HashMap<UUID, StarvationData>();
    private static final Map<UUID, FoodComaData> playerFoodComaData = new HashMap<UUID, FoodComaData>();
    private static final Random random = new Random();
    private static final int LEVEL_DELAY_TICKS = 12000;
    private static final int TOTAL_STARVATION_DURATION = 72000;
    public static StarvationStatusEffect STARVATION_EFFECT;
    public static FoodComaStatusEffect FOOD_COMA_EFFECT;

    public static void setStarvationEffect(StarvationStatusEffect effect) {
        STARVATION_EFFECT = effect;
    }

    public static void setFoodComaEffect(FoodComaStatusEffect effect) {
        FOOD_COMA_EFFECT = effect;
    }

    public static void updateStarvationEffects(class_1657 player) {
        if (!(player.method_37908() instanceof class_3218)) {
            return;
        }
        StarvationEffectManager.updateFoodComaEffects(player);
        class_3222 serverPlayer = (class_3222)player;
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.getOrDefault(playerId, new StarvationData());
        long currentTime = player.method_37908().method_8510();
        int foodLevel = player.method_7344().method_7586();
        if (foodLevel <= 0 && data.level == 0) {
            StarvationEffectManager.activateStarvation(player, data, currentTime);
        }
        if (data.level <= 0) {
            return;
        }
        StarvationEffectManager.checkStarvationDuration(player, data, currentTime);
        if (currentTime - data.lastUpdateTime < 20L) {
            return;
        }
        data.lastUpdateTime = currentTime;
        data.starvationTicks += 20;
        StarvationEffectManager.checkLevelIncrease(player, data, currentTime);
        StarvationEffectManager.applyStarvationEffects(player, data);
        StarvationEffectManager.updateParalysis(player, data);
        StarvationEffectManager.updateStarvationDamage(player, data);
        playerStarvationData.put(playerId, data);
    }

    public static void activateStarvationEffect(class_1657 player, int durationMinutes) {
        if (!(player.method_37908() instanceof class_3218)) {
            return;
        }
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.getOrDefault(playerId, new StarvationData());
        long currentTime = player.method_37908().method_8510();
        ++data.totalActivations;
        int baseLevel = Math.min(4, (data.totalActivations + 1) / 2);
        if (data.level == 0) {
            data.level = Math.max(1, baseLevel);
            data.effectStartTime = (int)currentTime;
            data.levelStartTime = (int)currentTime;
            data.starvationTicks = 0;
        } else {
            int newLevel = Math.min(4, data.level + baseLevel);
            if (newLevel > data.level) {
                data.level = newLevel;
                data.levelStartTime = (int)currentTime;
            }
            data.effectStartTime = (int)currentTime;
        }
        if (durationMinutes > 0) {
            // empty if block
        }
        StarvationEffectManager.applyStarvationEffects(player, data);
        String message = StarvationEffectManager.getActivationMessage(data.level, data.totalActivations);
        player.method_7353((class_2561)class_2561.method_43470((String)message), true);
        playerStarvationData.put(playerId, data);
    }

    private static void activateStarvation(class_1657 player, StarvationData data, long currentTime) {
        ++data.totalActivations;
        int baseLevel = Math.min(4, (data.totalActivations + 1) / 2);
        data.level = Math.max(1, baseLevel);
        data.levelStartTime = (int)currentTime;
        data.effectStartTime = (int)currentTime;
        data.starvationTicks = 0;
        String message = StarvationEffectManager.getActivationMessage(data.level, data.totalActivations);
        player.method_7353((class_2561)class_2561.method_43470((String)message), true);
    }

    private static String getActivationMessage(int level, int activations) {
        if (activations == 1) {
            return "\u00a7cYou are starving! This effect will last for 60 minutes.";
        }
        switch (level) {
            case 1: {
                return "\u00a76Starvation returns! Level 1 effects applied.";
            }
            case 2: {
                return "\u00a76Starvation intensifies! Now at level 2.";
            }
            case 3: {
                return "\u00a7cSevere starvation! Level 3 effects active.";
            }
            case 4: {
                return "\u00a74CRITICAL STARVATION! Maximum level 4 effects!";
            }
        }
        return "\u00a7cStarvation effect applied.";
    }

    private static void checkStarvationDuration(class_1657 player, StarvationData data, long currentTime) {
        long effectDuration = currentTime - (long)data.effectStartTime;
        if (effectDuration >= 72000L) {
            StarvationEffectManager.deactivateStarvation(player, data);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aThe starvation effect has passed."), true);
        }
    }

    private static void deactivateStarvation(class_1657 player, StarvationData data) {
        int previousActivations = data.totalActivations;
        StarvationEffectManager.resetStarvationEffects(player, data);
        data.totalActivations = previousActivations;
    }

    private static void checkLevelIncrease(class_1657 player, StarvationData data, long currentTime) {
        if (data.level == 0) {
            return;
        }
        int currentLevel = data.level++;
        long timeAtCurrentLevel = currentTime - (long)data.levelStartTime;
        if (timeAtCurrentLevel >= 12000L && currentLevel < 4) {
            data.levelStartTime = (int)currentTime;
            String message = StarvationEffectManager.getLevelUpMessage(data.level);
            player.method_7353((class_2561)class_2561.method_43470((String)message), true);
            StarvationEffectManager.applyStarvationEffects(player, data);
        }
    }

    private static String getLevelUpMessage(int level) {
        switch (level) {
            case 2: {
                return "\u00a76Your starvation is getting worse! Effects intensified.";
            }
            case 3: {
                return "\u00a7cCritical starvation! You feel very weak.";
            }
            case 4: {
                return "\u00a74LETHAL STARVATION! The effect will continue for its full duration.";
            }
        }
        return "\u00a7cStarvation level increased.";
    }

    public static void checkFoodComa(class_1657 player, int oldFoodLevel, int newFoodLevel) {
        if (!(player.method_37908() instanceof class_3218)) {
            return;
        }
        if (oldFoodLevel < 17 && newFoodLevel >= 17) {
            StarvationEffectManager.activateFoodComa(player);
        }
        StarvationEffectManager.updateFoodComaEffects(player);
    }

    private static void activateFoodComa(class_1657 player) {
        UUID playerId = player.method_5667();
        int duration = 6000 + random.nextInt(2400);
        player.method_6092(new class_1293(class_1294.field_5909, duration, 0, false, true));
        player.method_6092(new class_1293(class_1294.field_5911, duration, 0, false, true));
        if (FOOD_COMA_EFFECT != null) {
            player.method_6092(new class_1293((class_1291)FOOD_COMA_EFFECT, duration, 0, false, true));
        }
        if (player.method_5624()) {
            player.method_5728(false);
        }
        FoodComaData data = new FoodComaData();
        playerFoodComaData.put(playerId, data);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76 You overate! Now you have food coma for 5-7 minutes"), true);
    }

    private static void updateFoodComaEffects(class_1657 player) {
        UUID playerId = player.method_5667();
        FoodComaData data = playerFoodComaData.get(playerId);
        if (data == null) {
            return;
        }
        if (FOOD_COMA_EFFECT != null && !player.method_6059((class_1291)FOOD_COMA_EFFECT)) {
            playerFoodComaData.remove(playerId);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a Food coma passed, you can move normally again"), true);
            return;
        }
        class_1937 world = player.method_37908();
        if (player.method_24828() && (player.method_18798().field_1352 != 0.0 || player.method_18798().field_1350 != 0.0)) {
            ++data.walkingTicks;
            if (data.walkingTicks >= 100 && world.method_8510() - (long)data.lastDamageTick >= 100L) {
                player.method_5643(player.method_48923().method_48825(), 0.25f);
                data.lastDamageTick = (int)world.method_8510();
                data.walkingTicks = 0;
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c! Walking with a full stomach causes pain"), false);
            }
        } else {
            data.walkingTicks = 0;
        }
        if (data.nauseaCooldown <= 0) {
            if (random.nextDouble() < 0.02) {
                player.method_6092(new class_1293(class_1294.field_5916, (5 + random.nextInt(6)) * 20, 0, false, true));
                data.nauseaCooldown = (30 + random.nextInt(31)) * 20;
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7eYou feel nauseous from overeating..."), false);
            }
        } else {
            --data.nauseaCooldown;
        }
        if (player.method_5624()) {
            player.method_5728(false);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76Running with a full stomach is a bad idea"), false);
        }
    }

    private static void applyStarvationEffects(class_1657 player, StarvationData data) {
        StarvationEffectManager.clearStarvationEffects(player);
        if (data.level > 0 && STARVATION_EFFECT != null) {
            player.method_6092(new class_1293((class_1291)STARVATION_EFFECT, 200, data.level - 1, false, true));
        }
        switch (data.level) {
            case 1: {
                StarvationEffectManager.applyLevel1Effects(player, data);
                break;
            }
            case 2: {
                StarvationEffectManager.applyLevel2Effects(player, data);
                break;
            }
            case 3: {
                StarvationEffectManager.applyLevel3Effects(player, data);
                break;
            }
            case 4: {
                StarvationEffectManager.applyLevel4Effects(player, data);
                break;
            }
        }
    }

    private static void clearStarvationEffects(class_1657 player) {
        if (STARVATION_EFFECT != null) {
            player.method_6016((class_1291)STARVATION_EFFECT);
        }
        player.method_6016(class_1294.field_5913);
        player.method_6016(class_1294.field_5911);
        player.method_6016(class_1294.field_5901);
        player.method_6016(class_1294.field_5919);
        player.method_6016(class_1294.field_5909);
        player.method_6016(class_1294.field_5903);
    }

    private static void applyLevel1Effects(class_1657 player, StarvationData data) {
        if (player.method_5624()) {
            player.method_5728(false);
        }
    }

    private static void applyLevel2Effects(class_1657 player, StarvationData data) {
        StarvationEffectManager.applyLevel1Effects(player, data);
        player.method_6092(new class_1293(class_1294.field_5913, 200, -2, false, false));
        player.method_6092(new class_1293(class_1294.field_5911, 200, 0, false, false));
        player.method_6092(new class_1293(class_1294.field_5901, 200, 0, false, false));
    }

    private static void applyLevel3Effects(class_1657 player, StarvationData data) {
        StarvationEffectManager.applyLevel2Effects(player, data);
        player.method_6092(new class_1293(class_1294.field_5913, 200, -3, false, false));
        player.method_6092(new class_1293(class_1294.field_5911, 200, 1, false, false));
        player.method_6092(new class_1293(class_1294.field_5901, 200, 1, false, false));
        player.method_6092(new class_1293(class_1294.field_5919, 200, 0, false, false));
        player.method_6092(new class_1293(class_1294.field_5909, 200, 0, false, false));
        player.method_6092(new class_1293(class_1294.field_5903, 200, 0, false, false));
    }

    private static void applyLevel4Effects(class_1657 player, StarvationData data) {
        StarvationEffectManager.applyLevel3Effects(player, data);
        player.method_6092(new class_1293(class_1294.field_5913, 200, -5, false, false));
        player.method_6092(new class_1293(class_1294.field_5911, 200, 4, false, false));
        player.method_6092(new class_1293(class_1294.field_5901, 200, 2, false, false));
        player.method_6092(new class_1293(class_1294.field_5919, 200, 0, false, false));
        player.method_6092(new class_1293(class_1294.field_5909, 200, 2, false, false));
        player.method_6092(new class_1293(class_1294.field_5903, 200, 2, false, false));
    }

    private static void updateParalysis(class_1657 player, StarvationData data) {
        if (data.level < 2) {
            return;
        }
        if (data.isParalyzed) {
            player.method_18800(0.0, player.method_18798().field_1351, 0.0);
            player.field_6037 = true;
            player.method_6092(new class_1293(class_1294.field_5919, 40, 0, false, false));
            player.method_6092(new class_1293(class_1294.field_5909, 40, 10, false, false));
            if (data.paralysisCooldown <= 0) {
                data.isParalyzed = false;
                StarvationEffectManager.setNextParalysis(player, data);
            } else {
                --data.paralysisCooldown;
            }
        } else if (data.paralysisCooldown > 0) {
            --data.paralysisCooldown;
        } else {
            data.isParalyzed = true;
            data.paralysisCooldown = StarvationEffectManager.getParalysisDuration(data.level) * 20;
        }
    }

    private static void setNextParalysis(class_1657 player, StarvationData data) {
        data.paralysisCooldown = switch (data.level) {
            case 2 -> 6000;
            case 3 -> 4800;
            case 4 -> 3600;
            default -> 6000;
        };
    }

    private static int getParalysisDuration(int level) {
        switch (level) {
            case 2: {
                return 30;
            }
            case 3: {
                return 40;
            }
            case 4: {
                return 45;
            }
        }
        return 30;
    }

    private static void updateStarvationDamage(class_1657 player, StarvationData data) {
        float damage;
        if (data.level == 0) {
            return;
        }
        if (data.damageCooldown > 0) {
            --data.damageCooldown;
            return;
        }
        int damageCooldown = switch (data.level) {
            case 1 -> {
                damage = 0.25f;
                yield (10 + random.nextInt(50)) * 60 * 20;
            }
            case 2 -> {
                damage = 0.5f;
                yield (7 + random.nextInt(53)) * 60 * 20;
            }
            case 3 -> {
                damage = 0.5f;
                yield (3 + random.nextInt(57)) * 60 * 20;
            }
            case 4 -> {
                damage = 0.5f;
                yield 1200;
            }
            default -> {
                damage = 0.25f;
                yield 12000;
            }
        };
        player.method_5643(player.method_48923().method_48825(), damage);
        data.damageCooldown = damageCooldown;
    }

    public static int getHiddenFoodSlots(class_1657 player) {
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.get(playerId);
        if (data != null && data.level > 0) {
            switch (data.level) {
                case 1: {
                    return 8;
                }
                case 2: {
                    return 10;
                }
                case 3: {
                    return 12;
                }
                case 4: {
                    return 16;
                }
            }
        }
        return 7;
    }

    public static boolean canSleep(class_1657 player) {
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.get(playerId);
        return data == null || data.level == 0;
    }

    public static boolean canSprint(class_1657 player) {
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.get(playerId);
        FoodComaData foodComaData = playerFoodComaData.get(playerId);
        return (data == null || data.level == 0) && foodComaData == null;
    }

    public static int getStarvationLevel(class_1657 player) {
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.get(playerId);
        return data != null ? data.level : 0;
    }

    public static int getRemainingStarvationTime(class_1657 player) {
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.get(playerId);
        if (data != null && data.level > 0) {
            long currentTime = player.method_37908().method_8510();
            long effectDuration = currentTime - (long)data.effectStartTime;
            long remainingTicks = 72000L - effectDuration;
            return (int)Math.max(0L, remainingTicks / 20L);
        }
        return 0;
    }

    private static void resetStarvationEffects(class_1657 player, StarvationData data) {
        if (data.level > 0 || data.starvationTicks > 0) {
            data.level = 0;
            data.starvationTicks = 0;
            data.levelStartTime = 0;
            data.effectStartTime = 0;
            data.isParalyzed = false;
            data.paralysisCooldown = 0;
            data.damageCooldown = 0;
            StarvationEffectManager.clearStarvationEffects(player);
        }
    }

    public static int getStarvationLevelBasedOnActivations(class_1657 player) {
        UUID playerId = player.method_5667();
        StarvationData data = playerStarvationData.get(playerId);
        if (data != null) {
            return Math.min(4, (data.totalActivations + 1) / 2);
        }
        return 0;
    }

    public static class StarvationData {
        public int level = 0;
        public int starvationTicks = 0;
        public int levelStartTime = 0;
        public int effectStartTime = 0;
        public int paralysisCooldown = 0;
        public boolean isParalyzed = false;
        public int damageCooldown = 0;
        public long lastUpdateTime = 0L;
        public int totalActivations = 0;
    }

    public static class FoodComaData {
        public int walkingTicks = 0;
        public int lastDamageTick = 0;
        public int nauseaCooldown = 0;
    }
}

