/*
 * Decompiled with CFR 0.152.
 */
package com.ferrum.todd.zombie;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1642;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class ZombieStatsManager {
    private static final Random random = new Random();
    public static final double BASE_HEALTH = 28.0;
    public static final double BASE_DAMAGE = 6.0;
    public static final double BASE_SPEED = 0.4;
    public static final double BASE_ARMOR_CHANCE = 0.01;
    private static final double ARMOR_PART_CHANCE = 0.25;
    private static final ArmorTier[] ARMOR_TIERS = new ArmorTier[]{new ArmorTier(class_1802.field_8370, class_1802.field_8570, class_1802.field_8577, class_1802.field_8267), new ArmorTier(class_1802.field_8753, class_1802.field_8416, class_1802.field_8678, class_1802.field_8862), new ArmorTier(class_1802.field_8313, class_1802.field_8218, class_1802.field_8873, class_1802.field_8283), new ArmorTier(class_1802.field_8660, class_1802.field_8396, class_1802.field_8523, class_1802.field_8743), new ArmorTier(class_1802.field_8285, class_1802.field_8348, class_1802.field_8058, class_1802.field_8805)};
    private static final int BREAK_TIME_STONE = 100;
    private static final int BREAK_TIME_WOOD = 40;
    private static final int BREAK_TIME_DIRT = 20;
    private static final int BREAK_TIME_INSTANT = 1;
    private static final String[] BREAKABLE_BLOCKS = new String[]{"gravel", "sand", "dirt", "grass_block", "cobblestone", "stone", "oak_planks", "spruce_planks", "birch_planks", "jungle_planks", "acacia_planks", "dark_oak_planks", "oak_log", "spruce_log", "birch_log", "jungle_log", "acacia_log", "dark_oak_log"};

    public static void applyZombieStats(class_1642 zombie, class_1937 world) {
        if (world instanceof class_3218) {
            ZombieStatsManager.applyBaseStats(zombie);
            ZombieStatsManager.applyArmor(zombie, world);
            ZombieStatsManager.applySpecialAbilities(zombie, world);
        }
    }

    private static void applyBaseStats(class_1642 zombie) {
        zombie.method_6033(28.0f);
        zombie.method_5996(class_5134.field_23721).method_6192(6.0);
        zombie.method_5996(class_5134.field_23719).method_6192(0.4);
    }

    private static void applyArmor(class_1642 zombie, class_1937 world) {
        class_2338 playerPos;
        class_3218 serverWorld = (class_3218)world;
        long time = world.method_8532() % 24000L;
        int nightsSurvived = (int)(world.method_8532() / 24000L);
        double armorChance = 0.01 * Math.pow(2.0, nightsSurvived);
        int armorParts = 0;
        if (time >= 13000L && time < 18000L) {
            armorParts = 2;
        } else if (time >= 18000L && time < 22000L) {
            armorParts = 3;
        } else if (time >= 22000L || time < 1000L) {
            armorParts = 4;
        }
        if (time >= 18000L && random.nextDouble() < 0.33 && (playerPos = ZombieStatsManager.findNearestPlayer(zombie, 24)) != null) {
            ZombieStatsManager.spawnDiamondZombie(zombie, playerPos, world);
            return;
        }
        if (random.nextDouble() < armorChance && armorParts > 0) {
            ArmorTier tier = ZombieStatsManager.getRandomArmorTier(nightsSurvived);
            ZombieStatsManager.equipArmor(zombie, tier, armorParts);
        }
    }

    private static void applySpecialAbilities(class_1642 zombie, class_1937 world) {
        long time = world.method_8532() % 24000L;
        zombie.method_5971();
        if (time >= 6000L && time < 11000L) {
            ZombieStatsManager.enableBlockBreaking(zombie, ZombieStatsManager.getBreakTime(time));
        }
    }

    private static int getBreakTime(long time) {
        if (time >= 10000L) {
            return 100;
        }
        if (time >= 15000L) {
            return 1;
        }
        return 200;
    }

    private static void enableBlockBreaking(class_1642 zombie, int baseBreakTime) {
    }

    private static class_2338 findNearestPlayer(class_1642 zombie, int radius) {
        return zombie.method_24515();
    }

    private static void spawnDiamondZombie(class_1642 zombie, class_2338 pos, class_1937 world) {
        class_1642 diamondZombie = new class_1642(world);
        diamondZombie.method_5814((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        diamondZombie.method_6033(28.0f);
        diamondZombie.method_5996(class_5134.field_23721).method_6192(9.0);
        diamondZombie.method_5996(class_5134.field_23719).method_6192(0.48);
        ArmorTier diamondTier = ARMOR_TIERS[4];
        ZombieStatsManager.equipArmor(diamondZombie, diamondTier, 4);
        world.method_8649((class_1297)diamondZombie);
    }

    private static ArmorTier getRandomArmorTier(int nightsSurvived) {
        int maxTier = Math.min(4, nightsSurvived / 3);
        int tier = random.nextInt(maxTier + 1);
        return ARMOR_TIERS[tier];
    }

    private static void equipArmor(class_1642 zombie, ArmorTier tier, int parts) {
        if (parts >= 1 && random.nextDouble() < 0.25) {
            zombie.method_5673(class_1304.field_6166, new class_1799((class_1935)tier.boots));
        }
        if (parts >= 2 && random.nextDouble() < 0.25) {
            zombie.method_5673(class_1304.field_6172, new class_1799((class_1935)tier.leggings));
        }
        if (parts >= 3 && random.nextDouble() < 0.25) {
            zombie.method_5673(class_1304.field_6174, new class_1799((class_1935)tier.chestplate));
        }
        if (parts >= 4 && random.nextDouble() < 0.25) {
            zombie.method_5673(class_1304.field_6169, new class_1799((class_1935)tier.helmet));
        }
    }

    public static boolean canBreakBlock(class_2680 state) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
        String blockPath = blockId.method_12832();
        for (String breakable : BREAKABLE_BLOCKS) {
            if (!blockPath.contains(breakable)) continue;
            return true;
        }
        return false;
    }

    public static int getBlockBreakTime(class_2680 state, long time) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
        String blockPath = blockId.method_12832();
        int baseTime = blockPath.contains("cobblestone") || blockPath.contains("stone") ? 100 : (blockPath.contains("planks") || blockPath.contains("log") ? 40 : 20);
        if (time >= 15000L) {
            if (blockPath.contains("cobblestone") || blockPath.contains("stone")) {
                return 200;
            }
            return 1;
        }
        if (time >= 10000L) {
            return Math.max(100, baseTime / 2);
        }
        return baseTime;
    }

    private static class ArmorTier {
        public final class_1792 boots;
        public final class_1792 leggings;
        public final class_1792 chestplate;
        public final class_1792 helmet;

        public ArmorTier(class_1792 boots, class_1792 leggings, class_1792 chestplate, class_1792 helmet) {
            this.boots = boots;
            this.leggings = leggings;
            this.chestplate = chestplate;
            this.helmet = helmet;
        }
    }
}

