/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.tooltip;

import dev.ultimatchamp.enhancedtooltips.EnhancedTooltips;
import dev.ultimatchamp.enhancedtooltips.component.TooltipBackgroundComponent;
import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.DrawContextAccessor;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.OrderedTextTooltipComponentAccessor;
import dev.ultimatchamp.enhancedtooltips.util.EnhancedTooltipsTextVisitor;
import dev.ultimatchamp.enhancedtooltips.util.MatricesUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector2ic;

public class EnhancedTooltipsDrawer {
    private static final int EDGE_SPACING = 32;
    private static final int PAGE_SPACING = 12;
    private static long startTime = -1L;
    private static ItemStack lastStack = ItemStack.EMPTY;

    private static int getMaxHeight() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight() - 64;
    }

    private static int getMaxWidth() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 32;
    }

    public static void drawTooltip(GuiGraphics context, Font textRenderer, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, ItemStack currentStack) {
        if (components.isEmpty() || currentStack.isEmpty()) {
            startTime = -1L;
            lastStack = ItemStack.EMPTY;
        }
        if (components.isEmpty()) {
            return;
        }
        if (!currentStack.isEmpty()) {
            if (lastStack.isEmpty() || !ItemStack.matches((ItemStack)lastStack, (ItemStack)currentStack)) {
                startTime = System.nanoTime();
                lastStack = currentStack.copy();
            } else if (startTime == -1L) {
                startTime = System.nanoTime();
            }
        }
        TooltipBackgroundComponent backgroundComponent = EnhancedTooltipsDrawer.getBackgroundComponent(components);
        components.removeIf(component -> component.getHeight(textRenderer) == 0 || component.getWidth(textRenderer) == 0);
        MatricesUtil matrices = new MatricesUtil(context.pose());
        ArrayList<TooltipPage> pageList = new ArrayList<TooltipPage>();
        float scale = 1.0f;
        scale = EnhancedTooltipsConfig.load().general.scaleFactor;
        int maxWidth = (int)((float)EnhancedTooltipsDrawer.getMaxWidth() / scale);
        int totalWidth = 0;
        int pageHeight = -2;
        int maxHeight = (int)((float)EnhancedTooltipsDrawer.getMaxHeight() / scale);
        int spacing = components.size() > 1 ? 4 : 0;
        pageHeight += spacing;
        TooltipPage page = new TooltipPage();
        for (ClientTooltipComponent tooltipComponent : components) {
            int width = tooltipComponent.getWidth(textRenderer);
            int height = tooltipComponent.getHeight(textRenderer);
            if (width > maxWidth) {
                List<ClientTooltipComponent> wrappedComponents = EnhancedTooltipsDrawer.wrapComponent(tooltipComponent, textRenderer, maxWidth);
                Iterator<ClientTooltipComponent> iterator = wrappedComponents.iterator();
                while (iterator.hasNext()) {
                    ClientTooltipComponent wrappedComponent = iterator.next();
                    int wrappedWidth = wrappedComponent.getWidth(textRenderer);
                    int wrappedHeight = wrappedComponent.getHeight(textRenderer);
                    if (pageHeight + wrappedHeight > maxHeight) {
                        pageList.add(page);
                        totalWidth += page.width;
                        page = new TooltipPage();
                        pageHeight = -2;
                    }
                    page.components.add(wrappedComponent);
                    page.height = pageHeight += wrappedHeight;
                    page.width = Math.max(page.width, wrappedWidth);
                }
                continue;
            }
            if (pageHeight + height > maxHeight) {
                pageList.add(page);
                totalWidth += page.width;
                page = new TooltipPage();
                pageHeight = -2;
            }
            page.components.add(tooltipComponent);
            page.height = pageHeight += height;
            page.width = Math.max(page.width, width);
        }
        if (!page.components.isEmpty()) {
            pageList.add(page);
            totalWidth += page.width;
        }
        int scaledOffset = (int)(12.0f * scale) - 12;
        Vector2ic vector2ic = positioner.positionTooltip(context.guiWidth(), context.guiHeight(), x + scaledOffset, y - scaledOffset, (int)((float)totalWidth * scale), (int)((float)((TooltipPage)pageList.getFirst()).height * scale));
        int n = vector2ic.x();
        int o = vector2ic.y();
        for (TooltipPage tooltipPage : pageList) {
            tooltipPage.x = n;
            tooltipPage.y = pageList.size() > 1 ? o - 32 : o - 6;
            n += tooltipPage.width + 12;
        }
        matrices.pushMatrix();
        if (!currentStack.isEmpty() && EnhancedTooltipsConfig.load().popUpAnimation.enabled) {
            matrices.trans(x, y, 0.0f);
            float sec = EnhancedTooltipsConfig.load().popUpAnimation.time * 1000.0f;
            float elapsedTime = (float)(System.nanoTime() - startTime) / 1000000.0f / sec;
            float pop = 1.0f;
            if (elapsedTime < 0.5f) {
                pop = 1.0f + Math.abs((float)Math.sin((double)elapsedTime * Math.PI * 2.0)) * (EnhancedTooltipsConfig.load().popUpAnimation.magnitude / 10.0f * scale);
            }
            matrices.scal(pop, pop, 1.0f);
            matrices.trans(-x, -y, 0.0f);
        }
        matrices.scal(scale, scale, 1.0f);
        for (TooltipPage p : pageList) {
            if (pageList.getFirst() == p) {
                p.x = (int)((float)p.x / scale);
            }
            p.y = (int)((float)p.y / scale);
            if (backgroundComponent == null) {
                TooltipRenderUtil.renderTooltipBackground((GuiGraphics)context, (int)p.x, (int)p.y, (int)p.width, (int)p.height, (int)400, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"tooltip/background"));
                continue;
            }
            try {
                backgroundComponent.render(context, p.x, p.y, p.width, p.height, 400, pageList.indexOf(p));
            }
            catch (Exception e) {
                EnhancedTooltips.LOGGER.error("[EnhancedTooltips]", (Throwable)e);
            }
        }
        matrices.trans(0.0f, 0.0f, 400.0f);
        for (TooltipPage p : pageList) {
            int cx = p.x;
            int cy = p.y;
            for (ClientTooltipComponent component2 : p.components) {
                try {
                    component2.renderText(textRenderer, cx, cy, context.pose().last().pose(), ((DrawContextAccessor)context).getVertexConsumers());
                    component2.renderImage(textRenderer, cx, cy, p.width, p.height, context);
                    cy += component2.getHeight(textRenderer);
                    if (p != pageList.getFirst() || component2 != p.components.getFirst() || components.size() <= 1) continue;
                    cy += spacing;
                }
                catch (Exception e) {
                    EnhancedTooltips.LOGGER.error("[EnhancedTooltips]", (Throwable)e);
                }
            }
        }
        matrices.popMatrix();
    }

    private static TooltipBackgroundComponent getBackgroundComponent(List<ClientTooltipComponent> components) {
        for (ClientTooltipComponent component : components) {
            if (!(component instanceof TooltipBackgroundComponent)) continue;
            TooltipBackgroundComponent bgComponent = (TooltipBackgroundComponent)component;
            return bgComponent;
        }
        return null;
    }

    private static List<ClientTooltipComponent> wrapComponent(ClientTooltipComponent component, Font textRenderer, int maxWidth) {
        ArrayList<ClientTooltipComponent> wrappedComponents = new ArrayList<ClientTooltipComponent>();
        if (component instanceof OrderedTextTooltipComponentAccessor) {
            OrderedTextTooltipComponentAccessor orderedTextTooltipComponent = (OrderedTextTooltipComponentAccessor)component;
            Component text = EnhancedTooltipsTextVisitor.get(orderedTextTooltipComponent.getText());
            List lines = textRenderer.split((FormattedText)text, maxWidth);
            for (FormattedCharSequence line : lines) {
                wrappedComponents.add(ClientTooltipComponent.create((FormattedCharSequence)line));
            }
        } else {
            wrappedComponents.add(component);
        }
        return wrappedComponents;
    }

    private static class TooltipPage {
        private int x;
        private int y;
        private int width;
        private int height;
        private final List<ClientTooltipComponent> components;

        private TooltipPage() {
            this(0, 0, 0, 0, new ArrayList<ClientTooltipComponent>());
        }

        private TooltipPage(int x, int y, int width, int height, List<ClientTooltipComponent> components) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.components = components;
        }
    }
}

